/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureBase;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class DelegatingChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private ChannelPromise bridge;
    private final Channel channel;
    private final Promise<Void> promise;

    DelegatingChannelPromise(Promise<Void> promise, Channel channel) {
        this.channel = Objects.requireNonNull(channel);
        this.promise = Objects.requireNonNull(promise);
    }

    public Channel channel() {
        return this.channel;
    }

    public ChannelPromise setSuccess(Void result) {
        return this.setSuccess();
    }

    public ChannelPromise setSuccess() {
        this.promise.succeed();
        return this;
    }

    public boolean trySuccess() {
        return this.promise.tryComplete();
    }

    public ChannelPromise setFailure(Throwable cause) {
        this.promise.tryFail(cause);
        return this;
    }

    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        this.bridge().addListeners(new GenericFutureListener[]{listener});
        return this;
    }

    public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        this.bridge().addListeners(listeners);
        return this;
    }

    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        this.bridge().removeListeners(new GenericFutureListener[]{listener});
        return this;
    }

    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        this.bridge().removeListeners(listeners);
        return this;
    }

    public ChannelPromise sync() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public ChannelPromise syncUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    public ChannelPromise await() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public ChannelPromise awaitUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    public ChannelPromise unvoid() {
        return this;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean trySuccess(Void result) {
        return this.promise.tryComplete();
    }

    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFail(cause);
    }

    public boolean setUncancellable() {
        return true;
    }

    public boolean isSuccess() {
        return this.promise.future().succeeded();
    }

    public boolean isCancellable() {
        return false;
    }

    public Throwable cause() {
        return this.promise.future().cause();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        throw new UnsupportedOperationException();
    }

    public Void getNow() {
        return null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.promise.future().isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPromise bridge() {
        ChannelPromise p;
        DelegatingChannelPromise delegatingChannelPromise = this;
        synchronized (delegatingChannelPromise) {
            p = this.bridge;
            if (p == null) {
                ChannelPromise pr;
                p = pr = this.channel.newPromise();
                ((FutureBase)this.promise.future()).addListener((T result, Throwable failure) -> {
                    if (failure == null) {
                        pr.setSuccess();
                    } else {
                        pr.setFailure(failure);
                    }
                });
                this.bridge = p;
            }
        }
        return p;
    }
}

