/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnection;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.pool.PoolWaiter;
import io.vertx.core.internal.pool.SimpleConnectionPool;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ConnectionPool<C> {
    public static final Function<ContextInternal, ContextInternal> EVENT_LOOP_CONTEXT_PROVIDER = ctx -> {
        VertxInternal vertx = ctx.owner();
        return vertx.contextBuilder().withEventLoop(ctx.nettyEventLoop()).withWorkerPool(vertx.workerPool()).build();
    };

    public static <C> ConnectionPool<C> pool(PoolConnector<C> connector, int[] maxSizes) {
        return new SimpleConnectionPool<C>(connector, maxSizes);
    }

    public static <C> ConnectionPool<C> pool(PoolConnector<C> connector, int[] maxSizes, int maxWaiters) {
        return new SimpleConnectionPool<C>(connector, maxSizes, maxWaiters);
    }

    public ConnectionPool<C> connectionSelector(BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> var1);

    public ConnectionPool<C> contextProvider(Function<ContextInternal, ContextInternal> var1);

    public Future<Lease<C>> acquire(ContextInternal var1, int var2);

    @Deprecated(forRemoval=true)
    default public void acquire(ContextInternal context, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.acquire(context, kind).onComplete(handler);
    }

    public Future<Lease<C>> acquire(ContextInternal var1, PoolWaiter.Listener<C> var2, int var3);

    @Deprecated(forRemoval=true)
    default public void acquire(ContextInternal context, PoolWaiter.Listener<C> listener, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.acquire(context, listener, kind).onComplete(handler);
    }

    public Future<Boolean> cancel(PoolWaiter<C> var1);

    @Deprecated(forRemoval=true)
    default public void cancel(PoolWaiter<C> waiter, Handler<AsyncResult<Boolean>> handler) {
        this.cancel(waiter).onComplete(handler);
    }

    public Future<List<C>> evict(Predicate<C> var1);

    @Deprecated(forRemoval=true)
    default public void evict(Predicate<C> predicate, Handler<AsyncResult<List<C>>> handler) {
        this.evict(predicate).onComplete(handler);
    }

    public Future<List<Future<C>>> close();

    @Deprecated(forRemoval=true)
    default public void close(Handler<AsyncResult<List<Future<C>>>> handler) {
        this.close().onComplete(handler);
    }

    public int size();

    public int waiters();

    public int capacity();

    public int requests();
}

