/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;
import java.util.function.Function;

class Transformation<T, U>
extends Operation<U>
implements Completable<T> {
    private final Function<AsyncResult<T>, Future<U>> mapper;

    Transformation(ContextInternal context, Function<AsyncResult<T>, Future<U>> mapper) {
        super(context);
        this.mapper = mapper;
    }

    @Override
    public void complete(T result, Throwable failure) {
        FutureBase future;
        Future<T> f = failure == null ? Future.succeededFuture(result) : Future.failedFuture(failure);
        try {
            future = (FutureBase)this.mapper.apply(f);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this::handleInternal);
    }
}

