/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.http.WebSocketInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.VertxConnection;
import io.vertx.core.net.impl.VertxHandler;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public abstract class WebSocketImplBase<S extends WebSocket>
implements WebSocketInternal {
    private final boolean supportsContinuation;
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final int maxWebSocketFrameSize;
    private final int maxWebSocketMessageSize;
    private final VertxConnection conn;
    private ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private final InboundMessageQueue<WebSocketFrameInternal> pending;
    private MessageConsumer binaryHandlerRegistration;
    private MessageConsumer textHandlerRegistration;
    private String subProtocol;
    private Object metric;
    private Handler<Buffer> handler;
    private Handler<WebSocketFrameInternal> frameHandler;
    private FrameAggregator frameAggregator;
    private Handler<Buffer> pongHandler;
    private Handler<Void> drainHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean closing;
    private boolean closed;
    private Short closeStatusCode;
    private String closeReason;
    private MultiMap headers;

    WebSocketImplBase(ContextInternal context, final VertxConnection conn, MultiMap headers, boolean supportsContinuation, int maxWebSocketFrameSize, int maxWebSocketMessageSize, boolean registerWebSocketWriteHandlers) {
        this.supportsContinuation = supportsContinuation;
        if (registerWebSocketWriteHandlers) {
            this.textHandlerID = "__vertx.ws." + UUID.randomUUID();
            this.binaryHandlerID = "__vertx.ws." + UUID.randomUUID();
        } else {
            this.binaryHandlerID = null;
            this.textHandlerID = null;
        }
        this.conn = conn;
        this.context = context;
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
        this.maxWebSocketMessageSize = maxWebSocketMessageSize;
        this.pending = new InboundMessageQueue<WebSocketFrameInternal>(context.eventLoop(), context.executor()){

            @Override
            protected void handleResume() {
                conn.doResume();
            }

            @Override
            protected void handlePause() {
                conn.doPause();
            }

            @Override
            protected void handleMessage(WebSocketFrameInternal msg) {
                WebSocketImplBase.this.receiveFrame(msg);
            }
        };
        this.chctx = conn.channelHandlerContext();
        this.headers = headers;
    }

    void registerHandler(EventBus eventBus) {
        if (this.binaryHandlerID != null) {
            Handler<Message> binaryHandler = msg -> this.writeBinaryFrameInternal((Buffer)msg.body());
            Handler<Message> textHandler = msg -> this.writeTextFrameInternal((String)msg.body());
            this.binaryHandlerRegistration = eventBus.localConsumer(this.binaryHandlerID).handler(binaryHandler);
            this.textHandlerRegistration = eventBus.localConsumer(this.textHandlerID).handler(textHandler);
        }
    }

    final ContextInternal context() {
        return this.context;
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    @Override
    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    @Override
    public String textHandlerID() {
        return this.textHandlerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            return this.conn.writeQueueFull();
        }
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode, @Nullable String reason) {
        ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(statusCode, reason);
        CloseWebSocketFrame frame = new CloseWebSocketFrame(true, 0, byteBuf);
        return this.conn.shutdown(frame, timeout, unit);
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificates();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true));
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String subProtocol() {
        VertxConnection vertxConnection = this.conn;
        synchronized (vertxConnection) {
            return this.subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subProtocol(String subProtocol) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.subProtocol = subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short closeStatusCode() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.closeStatusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String closeReason() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.closeReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headers(MultiMap headers) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.headers = headers;
        }
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.writePartialMessage(WebSocketFrameType.BINARY, data, 0);
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        boolean isFinal;
        byte[] utf8Bytes = text.getBytes(StandardCharsets.UTF_8);
        boolean bl = isFinal = utf8Bytes.length <= this.maxWebSocketFrameSize;
        if (isFinal) {
            return this.writeFrame(new WebSocketFrameImpl(WebSocketFrameType.TEXT, utf8Bytes, true));
        }
        return this.writePartialMessage(WebSocketFrameType.TEXT, Buffer.buffer(utf8Bytes), 0);
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            return this.context.failedFuture("Ping cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pingFrame(data));
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            return this.context.failedFuture("Pong cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pongFrame(data));
    }

    private Future<Void> writePartialMessage(WebSocketFrameType frameType, Buffer data, int offset) {
        boolean isFinal;
        int end = offset + this.maxWebSocketFrameSize;
        if (end >= data.length()) {
            end = data.length();
            isFinal = true;
        } else {
            isFinal = false;
        }
        Buffer slice = data.slice(offset, end);
        WebSocketFrame frame = offset == 0 || !this.supportsContinuation ? new WebSocketFrameImpl(frameType, ((BufferInternal)slice).getByteBuf(), isFinal) : WebSocketFrame.continuationFrame(slice, isFinal);
        int newOffset = offset + this.maxWebSocketFrameSize;
        if (isFinal) {
            return this.writeFrame(frame);
        }
        this.writeFrame(frame);
        return this.writePartialMessage(frameType, data, newOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            if (this.isClosed()) {
                return this.context.failedFuture("WebSocket is closed");
            }
            PromiseInternal<Void> promise = this.context.promise();
            this.conn.writeToChannel((Object)this.encodeFrame((WebSocketFrameImpl)frame), promise);
            return promise.future();
        }
    }

    private void writeBinaryFrameInternal(Buffer data) {
        this.writeFrame(new WebSocketFrameImpl(WebSocketFrameType.BINARY, ((BufferInternal)data).getByteBuf()));
    }

    private void writeTextFrameInternal(String str) {
        this.writeFrame(new WebSocketFrameImpl(str));
    }

    private io.netty.handler.codec.http.websocketx.WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = VertxHandler.safeBuffer(frame.getBinaryData());
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported WebSocket msg " + frame);
    }

    void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.closed || this.closeStatusCode != null;
        }
    }

    void handleFrame(WebSocketFrameInternal frame) {
        switch (frame.type()) {
            case PING: {
                this.conn.writeToChannel(new PongWebSocketFrame(frame.getBinaryData().copy()));
                break;
            }
            case PONG: {
                Handler<Buffer> pongHandler = this.pongHandler();
                if (pongHandler == null) break;
                this.context.emit(frame.binaryData(), pongHandler);
                break;
            }
            case CLOSE: {
                this.handleCloseFrame(frame);
            }
        }
        this.pending.write(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCloseFrame(WebSocketFrameInternal closeFrame) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.closeStatusCode = closeFrame.closeStatusCode();
            this.closeReason = closeFrame.closeReason();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClose() {
        MessageConsumer textConsumer;
        MessageConsumer binaryConsumer;
        Handler<Throwable> exceptionHandler;
        Handler<Void> closeHandler;
        boolean graceful;
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            graceful = this.closeStatusCode != null;
            closeHandler = this.closeHandler;
            exceptionHandler = this.exceptionHandler;
            binaryConsumer = this.binaryHandlerRegistration;
            textConsumer = this.textHandlerRegistration;
            this.binaryHandlerRegistration = null;
            this.textHandlerRegistration = null;
            this.closeHandler = null;
            this.closed = true;
        }
        if (binaryConsumer != null) {
            binaryConsumer.unregister();
        }
        if (textConsumer != null) {
            textConsumer.unregister();
        }
        if (exceptionHandler != null && !graceful) {
            this.context.emit(HttpUtils.CONNECTION_CLOSED_EXCEPTION, exceptionHandler);
        }
        if (closeHandler != null) {
            this.context.emit(null, closeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFrame(WebSocketFrameInternal frame) {
        FrameAggregator frameAggregator;
        Handler<WebSocketFrameInternal> frameHandler;
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            frameHandler = this.frameHandler;
            frameAggregator = this.frameAggregator;
        }
        if (frameAggregator != null) {
            this.context.dispatch(frame, frameAggregator);
        }
        if (frameHandler != null) {
            this.context.dispatch(frame, frameHandler);
        }
        switch (frame.type()) {
            case CLOSE: {
                Handler<Void> endHandler = this.endHandler();
                if (endHandler == null) break;
                this.context.dispatch(endHandler);
                break;
            }
            case BINARY: 
            case TEXT: 
            case CONTINUATION: {
                Handler<Buffer> handler = this.handler();
                if (handler == null) break;
                this.context.dispatch(frame.binaryData(), handler);
                break;
            }
            case PONG: 
            case PING: {
                this.fetch(1L);
            }
        }
    }

    void closeConnection() {
        this.chctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S frameHandler(Handler<WebSocketFrame> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            this.frameHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket textMessageHandler(Handler<String> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            if (handler != null) {
                if (this.frameAggregator == null) {
                    this.frameAggregator = new FrameAggregator();
                }
                this.frameAggregator.textMessageHandler = handler;
            } else if (this.frameAggregator != null) {
                if (this.frameAggregator.binaryMessageHandler == null) {
                    this.frameAggregator = null;
                } else {
                    this.frameAggregator.textMessageHandler = null;
                    this.frameAggregator.textMessageBuffer = null;
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S binaryMessageHandler(Handler<Buffer> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            if (handler != null) {
                if (this.frameAggregator == null) {
                    this.frameAggregator = new FrameAggregator();
                }
                this.frameAggregator.binaryMessageHandler = handler;
            } else if (this.frameAggregator != null) {
                if (this.frameAggregator.textMessageHandler == null) {
                    this.frameAggregator = null;
                } else {
                    this.frameAggregator.binaryMessageHandler = null;
                    this.frameAggregator.binaryMessageBuffer = null;
                }
            }
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocket pongHandler(Handler<Buffer> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            this.pongHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> pongHandler() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.pongHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteQueueDrained(Void v) {
        Handler<Void> handler;
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            handler = this.drainHandler;
        }
        if (handler != null) {
            this.context.dispatch(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Handler<Throwable> handler;
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            this.context.dispatch(t, handler);
        }
    }

    void handleConnectionClosed() {
        this.handleClose();
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    synchronized Object getMetric() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S handler(Handler<Buffer> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.handler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> handler() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S endHandler(Handler<Void> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.endHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Void> endHandler() {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            return this.endHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S exceptionHandler(Handler<Throwable> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.exceptionHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S closeHandler(Handler<Void> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            this.closeHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S shutdownHandler(Handler<Void> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
        }
        this.conn.shutdownHandler(handler);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S drainHandler(Handler<Void> handler) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            this.drainHandler = handler;
            return (S)this;
        }
    }

    public S pause() {
        this.pending.pause();
        return (S)this;
    }

    public S fetch(long amount) {
        this.pending.fetch(amount);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S setWriteQueueMaxSize(int maxSize) {
        WebSocketImplBase webSocketImplBase = this;
        synchronized (webSocketImplBase) {
            this.checkClosed();
            this.conn.doSetWriteQueueMaxSize(maxSize);
            return (S)this;
        }
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    private class FrameAggregator
    implements Handler<WebSocketFrameInternal> {
        private Handler<String> textMessageHandler;
        private Handler<Buffer> binaryMessageHandler;
        private Buffer textMessageBuffer;
        private Buffer binaryMessageBuffer;

        private FrameAggregator() {
        }

        @Override
        public void handle(WebSocketFrameInternal frame) {
            switch (frame.type()) {
                case TEXT: {
                    this.handleTextFrame(frame);
                    break;
                }
                case BINARY: {
                    this.handleBinaryFrame(frame);
                    break;
                }
                case CONTINUATION: {
                    if (this.textMessageBuffer != null && this.textMessageBuffer.length() > 0) {
                        this.handleTextFrame(frame);
                        break;
                    }
                    if (this.binaryMessageBuffer == null || this.binaryMessageBuffer.length() <= 0) break;
                    this.handleBinaryFrame(frame);
                }
            }
        }

        private void handleTextFrame(WebSocketFrameInternal frame) {
            BufferInternal frameBuffer = BufferInternal.buffer(frame.getBinaryData());
            if (this.textMessageBuffer == null) {
                this.textMessageBuffer = frameBuffer;
            } else {
                this.textMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.textMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.textMessageBuffer.length() - frameBuffer.length();
                this.textMessageBuffer = null;
                String msg = "Cannot process text frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                String fullMessage = this.textMessageBuffer.toString();
                this.textMessageBuffer = null;
                if (this.textMessageHandler != null) {
                    this.textMessageHandler.handle(fullMessage);
                }
            }
        }

        private void handleBinaryFrame(WebSocketFrameInternal frame) {
            BufferInternal frameBuffer = BufferInternal.buffer(frame.getBinaryData());
            if (this.binaryMessageBuffer == null) {
                this.binaryMessageBuffer = frameBuffer;
            } else {
                this.binaryMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.binaryMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.binaryMessageBuffer.length() - frameBuffer.length();
                this.binaryMessageBuffer = null;
                String msg = "Cannot process binary frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                Buffer fullMessage = this.binaryMessageBuffer.copy();
                this.binaryMessageBuffer = null;
                if (this.binaryMessageHandler != null) {
                    this.binaryMessageHandler.handle(fullMessage);
                }
            }
        }
    }
}

