/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

@VertxGen
public interface HttpConnection {
    default public int getWindowSize() {
        return -1;
    }

    @Fluent
    default public HttpConnection setWindowSize(int windowSize) {
        return this;
    }

    @Fluent
    default public HttpConnection goAway(long errorCode) {
        return this.goAway(errorCode, -1);
    }

    @Fluent
    default public HttpConnection goAway(long errorCode, int lastStreamId) {
        return this.goAway(errorCode, lastStreamId, null);
    }

    @Fluent
    public HttpConnection goAway(long var1, int var3, Buffer var4);

    @Fluent
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> var1);

    @Fluent
    public HttpConnection shutdownHandler(@Nullable Handler<Void> var1);

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    public Future<Void> shutdown(long var1, TimeUnit var3);

    @Fluent
    public HttpConnection closeHandler(Handler<Void> var1);

    default public Future<Void> close() {
        return this.shutdown(0L, TimeUnit.SECONDS);
    }

    public Http2Settings settings();

    public Future<Void> updateSettings(Http2Settings var1);

    public Http2Settings remoteSettings();

    @Fluent
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> var1);

    public Future<Buffer> ping(Buffer var1);

    @Fluent
    public HttpConnection pingHandler(@Nullable Handler<Buffer> var1);

    @Fluent
    public HttpConnection exceptionHandler(Handler<Throwable> var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    public SocketAddress remoteAddress(boolean var1);

    @CacheReturn
    public SocketAddress localAddress();

    public SocketAddress localAddress(boolean var1);

    public boolean isSsl();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException;

    public String indicatedServerName();
}

