/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.Http1xServerResponse;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.http.impl.WebSocketConnectionImpl;
import io.vertx.core.impl.future.FutureImpl;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.VertxConnection;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ServerWebSocketHandshaker
extends FutureImpl<ServerWebSocket>
implements ServerWebSocketHandshake,
ServerWebSocket {
    private final Http1xServerRequest request;
    private final HttpServerOptions options;
    private final WebSocketServerHandshaker handshaker;
    private boolean done;

    public ServerWebSocketHandshaker(Http1xServerRequest request, WebSocketServerHandshaker handshaker, HttpServerOptions options) {
        super(request.context);
        this.request = request;
        this.handshaker = handshaker;
        this.options = options;
    }

    @Override
    public @Nullable String scheme() {
        return this.request.scheme();
    }

    @Override
    public @Nullable HostAndPort authority() {
        return this.request.authority();
    }

    @Override
    public String uri() {
        return this.request.uri();
    }

    @Override
    public String path() {
        return this.request.path();
    }

    @Override
    public String query() {
        return this.request.query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ServerWebSocket> accept() {
        ServerWebSocket ws;
        ServerWebSocketHandshaker serverWebSocketHandshaker = this;
        synchronized (serverWebSocketHandshaker) {
            if (this.done) {
                throw new IllegalStateException();
            }
            this.done = true;
        }
        try {
            ws = this.acceptHandshake();
        }
        catch (Exception e) {
            return this.rejectHandshake(HttpResponseStatus.BAD_REQUEST.code()).transform((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    return this.request.context.failedFuture(e);
                }
                return (Future)ar;
            });
        }
        this.tryComplete(ws);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> reject(int sc) {
        ServerWebSocketHandshaker serverWebSocketHandshaker = this;
        synchronized (serverWebSocketHandshaker) {
            if (this.done) {
                throw new IllegalStateException();
            }
            this.done = true;
        }
        this.tryFail(new RejectedExecutionException());
        return this.rejectHandshake(sc);
    }

    @Override
    public MultiMap headers() {
        return this.request.headers();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.request.localAddress();
    }

    @Override
    public boolean isSsl() {
        return this.request.isSSL();
    }

    @Override
    public SSLSession sslSession() {
        return this.request.sslSession();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return Arrays.asList(this.sslSession().getPeerCertificates());
    }

    private Future<Void> rejectHandshake(int sc) {
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)sc);
        Http1xServerResponse response = this.request.response();
        return response.setStatusCode(sc).end(status.reasonPhrase());
    }

    private ServerWebSocket acceptHandshake() {
        Http1xServerConnection httpConn = (Http1xServerConnection)this.request.connection();
        ChannelHandlerContext chctx = httpConn.channelHandlerContext();
        Channel channel = chctx.channel();
        Http1xServerResponse response = this.request.response();
        Object requestMetric = this.request.metric;
        this.handshaker.handshake(channel, this.request.nettyRequest(), (HttpHeaders)response.headers(), channel.newPromise());
        response.completeHandshake();
        ChannelPipeline pipeline = channel.pipeline();
        ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        VertxHandler<WebSocketConnectionImpl> handler = VertxHandler.create(ctx -> {
            long closingTimeoutMS = this.options.getWebSocketClosingTimeout() >= 0 ? (long)this.options.getWebSocketClosingTimeout() * 1000L : 0L;
            WebSocketConnectionImpl webSocketConn = new WebSocketConnectionImpl(this.request.context, (ChannelHandlerContext)ctx, true, closingTimeoutMS, httpConn.metrics);
            ServerWebSocketImpl webSocket = new ServerWebSocketImpl(this.request.context(), (VertxConnection)webSocketConn, this.handshaker.version() != WebSocketVersion.V00, this.request, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize(), this.options.isRegisterWebSocketWriteHandlers());
            String subprotocol = this.handshaker.selectedSubprotocol();
            webSocket.subProtocol(subprotocol);
            webSocketConn.webSocket(webSocket);
            webSocketConn.metric(webSocketConn.metric());
            return webSocketConn;
        });
        CompletableFuture latch = new CompletableFuture();
        httpConn.context().execute(() -> {
            pipeline.replace(VertxHandler.class, "handler", (ChannelHandler)handler);
            latch.complete(null);
        });
        try {
            latch.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServerWebSocketImpl webSocket = (ServerWebSocketImpl)handler.getConnection().webSocket();
        if (Metrics.METRICS_ENABLED && httpConn.metrics != null) {
            webSocket.setMetric(httpConn.metrics.connected(httpConn.metric(), requestMetric, this));
        }
        webSocket.registerHandler(httpConn.context().owner().eventBus());
        return webSocket;
    }

    @Override
    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket handler(Handler<Buffer> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket fetch(long amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket drainHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket closeHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WebSocket shutdownHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WebSocket textMessageHandler(@Nullable Handler<String> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WebSocket binaryMessageHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WebSocket pongHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String binaryHandlerID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String textHandlerID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String subProtocol() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short closeStatusCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String closeReason() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> end() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode, @Nullable String reason) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> write(Buffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean writeQueueFull() {
        throw new UnsupportedOperationException();
    }
}

