/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpClientBase;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.impl.MessageWrite;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.WriteStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

class Http2ClientConnection
extends Http2ConnectionBase
implements HttpClientConnectionInternal {
    private final HttpClientBase client;
    private final ClientMetrics metrics;
    private final HostAndPort authority;
    private final boolean pooled;
    private Handler<Void> evictionHandler = DEFAULT_EVICTION_HANDLER;
    private Handler<Long> concurrencyChangeHandler = DEFAULT_CONCURRENCY_CHANGE_HANDLER;
    private long expirationTimestamp;
    private boolean evicted;

    Http2ClientConnection(HttpClientBase client, ContextInternal context, HostAndPort authority, VertxHttp2ConnectionHandler connHandler, ClientMetrics metrics, boolean pooled) {
        super(context, connHandler);
        this.metrics = metrics;
        this.client = client;
        this.authority = authority;
        this.pooled = pooled;
    }

    @Override
    public HostAndPort authority() {
        return this.authority;
    }

    @Override
    public boolean pooled() {
        return this.pooled;
    }

    @Override
    public Http2ClientConnection evictionHandler(Handler<Void> handler) {
        this.evictionHandler = handler;
        return this;
    }

    @Override
    public Http2ClientConnection concurrencyChangeHandler(Handler<Long> handler) {
        this.concurrencyChangeHandler = handler;
        return this;
    }

    @Override
    public long concurrency() {
        long http2MaxConcurrency;
        long concurrency = this.remoteSettings().getMaxConcurrentStreams();
        long l = http2MaxConcurrency = this.client.options().getHttp2MultiplexingLimit() <= 0 ? Long.MAX_VALUE : (long)this.client.options().getHttp2MultiplexingLimit();
        if (http2MaxConcurrency > 0L) {
            concurrency = Math.min(concurrency, http2MaxConcurrency);
        }
        return concurrency;
    }

    @Override
    public long activeStreams() {
        return this.handler.connection().numActiveStreams();
    }

    @Override
    boolean onGoAwaySent(GoAway goAway) {
        boolean goneAway = super.onGoAwaySent(goAway);
        if (goneAway) {
            this.tryEvict();
        }
        return goneAway;
    }

    @Override
    boolean onGoAwayReceived(GoAway goAway) {
        boolean goneAway = super.onGoAwayReceived(goAway);
        if (goneAway) {
            this.tryEvict();
        }
        return goneAway;
    }

    private void tryEvict() {
        if (!this.evicted) {
            this.evicted = true;
            this.evictionHandler.handle(null);
        }
    }

    @Override
    protected void concurrencyChanged(long concurrency) {
        int limit = this.client.options().getHttp2MultiplexingLimit();
        if (limit > 0) {
            concurrency = Math.min(concurrency, (long)limit);
        }
        this.concurrencyChangeHandler.handle(concurrency);
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    HttpClientStream upgradeStream(Object metric, Object trace, ContextInternal context) throws Exception {
        StreamImpl stream = this.createStream2(context);
        stream.init(this.handler.connection().stream(1));
        stream.metric = metric;
        stream.trace = trace;
        stream.requestEnded = true;
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<HttpClientStream> createStream(ContextInternal context) {
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                StreamImpl stream = this.createStream2(context);
                return context.succeededFuture(stream);
            }
            catch (Exception e) {
                return context.failedFuture(e);
            }
        }
    }

    private StreamImpl createStream2(ContextInternal context) {
        return new StreamImpl(this, context, false);
    }

    private void recycle() {
        int timeout = this.client.options().getHttp2KeepAliveTimeout();
        this.expirationTimestamp = timeout > 0 ? System.currentTimeMillis() + (long)timeout * 1000L : 0L;
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    @Override
    public long lastResponseReceivedTimestamp() {
        return 0L;
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Stream stream = (Stream)this.stream(streamId);
        if (!stream.stream.isTrailersReceived()) {
            stream.onHeaders(headers, streamPriority);
            if (endOfStream) {
                stream.onEnd();
            }
        } else {
            stream.onEnd(new Http2HeadersAdaptor(headers));
        }
    }

    private void metricsEnd(Stream stream) {
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.bytesRead());
        }
    }

    @Override
    public synchronized void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Handler pushHandler;
        StreamImpl stream = (StreamImpl)this.stream(streamId);
        if (stream != null && (pushHandler = stream.pushHandler) != null) {
            Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
            StreamImpl pushStream = new StreamImpl(this, this.context, true);
            pushStream.init(promisedStream);
            HttpClientPush push = new HttpClientPush(headers, pushStream);
            if (this.metrics != null) {
                Object metric = this.metrics.requestBegin(headers.path().toString(), push);
                pushStream.metric = metric;
                this.metrics.requestEnd(metric, 0L);
            }
            stream.context.dispatch(push, pushHandler);
            return;
        }
        this.handler.writeReset(promisedStreamId, Http2Error.CANCEL.code());
    }

    @Override
    protected void handleIdle(IdleStateEvent event) {
        if (this.handler.connection().local().numActiveStreams() > 0) {
            super.handleIdle(event);
        }
    }

    public static VertxHttp2ConnectionHandler<Http2ClientConnection> createHttp2ConnectionHandler(HttpClientBase client, ClientMetrics metrics, ContextInternal context, boolean upgrade, Object socketMetric, HostAndPort authority, boolean pooled) {
        HttpClientOptions options = client.options();
        HttpClientMetrics met = client.metrics();
        Http2ConnectionHandler handler = new VertxHttp2ConnectionHandlerBuilder().server(false).useDecompression(client.options().isDecompressionSupported()).gracefulShutdownTimeoutMillis(0L).initialSettings(client.options().getInitialSettings()).connectionFactory(connHandler -> {
            Http2ClientConnection conn = new Http2ClientConnection(client, context, authority, (VertxHttp2ConnectionHandler)((Object)connHandler), metrics, pooled);
            if (metrics != null) {
                Object m = socketMetric;
                conn.metric(m);
            }
            return conn;
        }).logEnabled(options.getLogActivity()).build();
        handler.addHandler(conn -> {
            if (options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(options.getHttp2ConnectionWindowSize());
            }
            if (metrics != null && !upgrade) {
                met.endpointConnected(metrics);
            }
        });
        handler.removeHandler(conn -> {
            if (metrics != null) {
                met.endpointDisconnected(metrics);
            }
            conn.tryEvict();
        });
        return handler;
    }

    static class StreamImpl
    extends Stream
    implements HttpClientStream {
        StreamImpl(Http2ClientConnection conn, ContextInternal context, boolean push) {
            super(conn, context, push);
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        @Override
        public void earlyHintsHandler(Handler<MultiMap> handler) {
            this.earlyHintsHandler = handler;
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
            this.unknownFrameHandler = handler;
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
            this.pushHandler = handler;
        }

        public StreamImpl drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        @Override
        public StreamImpl exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            return !this.isNotWritable();
        }

        @Override
        public boolean isNotWritable() {
            return !this.isWritable();
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
            this.priorityHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        public StreamPriority priority() {
            return super.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            super.updatePriority(streamPriority);
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        void handleEnd(MultiMap trailers) {
            if (this.endHandler != null) {
                this.endHandler.handle(trailers);
            }
        }

        @Override
        void handleData(Buffer buf) {
            if (this.chunkHandler != null) {
                this.chunkHandler.handle(buf);
            }
        }

        @Override
        void handleReset(long errorCode) {
            this.handleException(new StreamResetException(errorCode));
        }

        @Override
        void handleWriteQueueDrained() {
            Handler handler = this.drainHandler;
            if (handler != null) {
                this.context.dispatch(null, handler);
            }
        }

        @Override
        void handleCustomFrame(HttpFrame frame) {
            if (this.unknownFrameHandler != null) {
                this.unknownFrameHandler.handle(frame);
            }
        }

        @Override
        void handlePriorityChange(StreamPriority streamPriority) {
            if (this.priorityHandler != null) {
                this.priorityHandler.handle(streamPriority);
            }
        }

        @Override
        void handleContinue() {
            if (this.continueHandler != null) {
                this.continueHandler.handle(null);
            }
        }

        @Override
        void handleEarlyHints(MultiMap headers) {
            if (this.earlyHintsHandler != null) {
                this.earlyHintsHandler.handle(headers);
            }
        }

        @Override
        void handleException(Throwable exception) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(exception);
            }
        }

        @Override
        public Future<Void> writeHead(final HttpRequestHead request, boolean chunked, final ByteBuf buf, final boolean end, final StreamPriority priority, final boolean connect) {
            this.priority(priority);
            final PromiseInternal promise = this.context.promise();
            this.write(new MessageWrite(){

                @Override
                public void write() {
                    this.writeHeaders(request, buf, end, priority, connect, promise);
                }

                @Override
                public void cancel(Throwable cause) {
                    promise.fail(cause);
                }
            });
            return promise.future();
        }

        private void writeHeaders(HttpRequestHead request, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Promise<Void> promise) {
            boolean e;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.method((CharSequence)request.method.name());
            if (request.method == HttpMethod.CONNECT) {
                if (request.authority == null) {
                    throw new IllegalArgumentException("Missing :authority / host header");
                }
                headers.authority((CharSequence)request.authority);
                e = false;
            } else {
                headers.path((CharSequence)request.uri);
                headers.scheme((CharSequence)(((Http2ClientConnection)this.conn).isSsl() ? "https" : "http"));
                if (request.authority != null) {
                    headers.authority((CharSequence)request.authority);
                }
                e = end;
            }
            if (request.headers != null && request.headers.size() > 0) {
                for (Map.Entry header : request.headers) {
                    headers.add((Object)HttpUtils.toLowerCase((CharSequence)header.getKey()), (Object)((CharSequence)header.getValue()));
                }
            }
            if (((Http2ClientConnection)this.conn).client.options().isDecompressionSupported() && headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) == null) {
                headers.set((Object)HttpHeaderNames.ACCEPT_ENCODING, (Object)Http1xClientConnection.determineCompressionAcceptEncoding());
            }
            try {
                this.createStream(request, (Http2Headers)headers);
            }
            catch (Http2Exception ex) {
                promise.fail(ex);
                this.handleException(ex);
                return;
            }
            if (buf != null) {
                this.doWriteHeaders((Http2Headers)headers, false, false, null);
                this.doWriteData(buf, e, promise);
            } else {
                this.doWriteHeaders((Http2Headers)headers, e, true, promise);
            }
        }

        private void createStream(HttpRequestHead head, Http2Headers headers) throws Http2Exception {
            VertxTracer tracer;
            int id = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().lastStreamCreated();
            id = id == 0 ? 1 : (id += 2);
            head.id = id;
            head.remoteAddress = ((Http2ClientConnection)this.conn).remoteAddress();
            Http2Stream stream = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().createStream(id, false);
            this.init(stream);
            if (((Http2ClientConnection)this.conn).metrics != null) {
                this.metric = ((Http2ClientConnection)this.conn).metrics.requestBegin(headers.path().toString(), head);
            }
            if ((tracer = this.context.tracer()) != null) {
                BiConsumer<String, String> headers_ = (key, val) -> new Http2HeadersAdaptor(headers).add((String)key, (String)val);
                String operation = head.traceOperation;
                if (operation == null) {
                    operation = headers.method().toString();
                }
                this.trace = tracer.sendRequest(this.context, SpanKind.RPC, ((Http2ClientConnection)this.conn).client.options().getTracingPolicy(), head, operation, headers_, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }

        @Override
        public Future<Void> writeBuffer(ByteBuf buf, boolean end) {
            PromiseInternal<Void> promise = this.context.promise();
            this.writeData(buf, end, promise);
            return promise.future();
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
        }

        @Override
        public void reset(Throwable cause) {
            long code = cause instanceof StreamResetException ? ((StreamResetException)cause).getCode() : (cause instanceof TimeoutException ? 8L : 0L);
            ((Http2ClientConnection)this.conn).context.emit(code, this::writeReset);
        }

        @Override
        public HttpClientConnectionInternal connection() {
            return (HttpClientConnectionInternal)((Object)this.conn);
        }
    }

    static abstract class Stream
    extends VertxHttp2Stream<Http2ClientConnection> {
        private final boolean push;
        private HttpResponseHead response;
        protected Object metric;
        protected Object trace;
        protected boolean requestEnded;
        private boolean responseEnded;
        protected Handler<HttpResponseHead> headHandler;
        protected Handler<Buffer> chunkHandler;
        protected Handler<MultiMap> endHandler;
        protected Handler<StreamPriority> priorityHandler;
        protected Handler<Void> drainHandler;
        protected Handler<Void> continueHandler;
        protected Handler<MultiMap> earlyHintsHandler;
        protected Handler<HttpFrame> unknownFrameHandler;
        protected Handler<Throwable> exceptionHandler;
        protected Handler<HttpClientPush> pushHandler;
        protected Handler<Void> closeHandler;

        Stream(Http2ClientConnection conn, ContextInternal context, boolean push) {
            super(conn, context);
            this.push = push;
        }

        void onContinue() {
            this.context.emit(null, v -> this.handleContinue());
        }

        void onEarlyHints(MultiMap headers) {
            this.context.emit(null, v -> this.handleEarlyHints(headers));
        }

        abstract void handleContinue();

        abstract void handleEarlyHints(MultiMap var1);

        public Object metric() {
            return this.metric;
        }

        public Object trace() {
            return this.trace;
        }

        @Override
        void doWriteData(ByteBuf chunk, boolean end, Promise<Void> promise) {
            super.doWriteData(chunk, end, promise);
        }

        @Override
        void doWriteHeaders(Http2Headers headers, boolean end, boolean checkFlush, Promise<Void> promise) {
            this.isConnect = "CONNECT".contentEquals(headers.method());
            super.doWriteHeaders(headers, end, checkFlush, promise);
        }

        @Override
        protected void doWriteReset(long code) {
            if (!this.requestEnded || !this.responseEnded) {
                super.doWriteReset(code);
            }
        }

        @Override
        protected void endWritten() {
            this.requestEnded = true;
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestEnd(this.metric, this.bytesWritten());
            }
        }

        @Override
        void onEnd(MultiMap trailers) {
            ((Http2ClientConnection)this.conn).metricsEnd(this);
            this.responseEnded = true;
            super.onEnd(trailers);
        }

        @Override
        void onReset(long code) {
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            super.onReset(code);
        }

        @Override
        void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
            if (streamPriority != null) {
                this.priority(streamPriority);
            }
            if (this.response == null) {
                String statusMessage;
                int status;
                try {
                    status = Integer.parseInt(headers.status().toString());
                    statusMessage = HttpResponseStatus.valueOf((int)status).reasonPhrase();
                }
                catch (Exception e) {
                    this.handleException(e);
                    this.writeReset(1L);
                    return;
                }
                if (status == 100) {
                    this.onContinue();
                    return;
                }
                if (status == 103) {
                    HeadersMultiMap headersMultiMap = HeadersMultiMap.httpHeaders();
                    this.removeStatusHeaders(headers);
                    for (Map.Entry header : headers) {
                        headersMultiMap.add((CharSequence)header.getKey(), (CharSequence)header.getValue());
                    }
                    this.onEarlyHints(headersMultiMap);
                    return;
                }
                this.response = new HttpResponseHead(HttpVersion.HTTP_2, status, statusMessage, new Http2HeadersAdaptor(headers));
                this.removeStatusHeaders(headers);
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.responseBegin(this.metric, this.response);
                }
                if (this.headHandler != null) {
                    this.context.emit(this.response, this.headHandler);
                }
            }
        }

        private void removeStatusHeaders(Http2Headers headers) {
            headers.remove((Object)HttpHeaders.PSEUDO_STATUS);
        }

        @Override
        void onClose() {
            VertxTracer tracer;
            if (!(((Http2ClientConnection)this.conn).metrics == null || this.requestEnded && this.responseEnded)) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            if ((tracer = this.context.tracer()) != null && this.trace != null) {
                HttpClosedException err = this.responseEnded && this.requestEnded ? null : HttpUtils.STREAM_CLOSED_EXCEPTION;
                tracer.receiveResponse(this.context, this.response, this.trace, err, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
            }
            if (!this.responseEnded) {
                this.onException(HttpUtils.STREAM_CLOSED_EXCEPTION);
            }
            super.onClose();
            if (!this.push) {
                ((Http2ClientConnection)this.conn).recycle();
            }
            if (this.closeHandler != null) {
                this.closeHandler.handle(null);
            }
        }
    }
}

