/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import java.util.ArrayList;
import java.util.Map;

public class NetClientOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setApplicationLayerProtocols(list);
                    break;
                }
                case "hostnameVerificationAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostnameVerificationAlgorithm((String)member.getValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                }
            }
        }
    }

    static void toJson(NetClientOptions obj, JsonObject json) {
        NetClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetClientOptions obj, Map<String, Object> json) {
        if (obj.getApplicationLayerProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getApplicationLayerProtocols().forEach(item -> array.add(item));
            json.put("applicationLayerProtocols", array);
        }
        if (obj.getHostnameVerificationAlgorithm() != null) {
            json.put("hostnameVerificationAlgorithm", obj.getHostnameVerificationAlgorithm());
        }
        json.put("reconnectAttempts", obj.getReconnectAttempts());
        json.put("reconnectInterval", obj.getReconnectInterval());
    }
}

