/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpEventHandler;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpClientResponseImpl.class);
    private final HttpVersion version;
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestBase request;
    private final HttpConnection conn;
    private final HttpClientStream stream;
    private HttpEventHandler eventHandler;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<StreamPriority> priorityHandler;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(HttpClientRequestBase request, HttpVersion version, HttpClientStream stream, int statusCode, String statusMessage, MultiMap headers) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.request = request;
        this.stream = stream;
        this.conn = stream.connection();
        this.headers = headers;
    }

    private HttpEventHandler eventHandler(boolean create) {
        if (this.eventHandler == null && create) {
            this.eventHandler = new HttpEventHandler(this.request.context);
        }
        return this.eventHandler;
    }

    @Override
    public HttpClientRequestBase request() {
        return this.request;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers.get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers == null) {
                this.trailers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
            }
            return this.trailers;
        }
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers != null ? this.trailers.get(trailerName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> cookies() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
                this.cookies.addAll(this.headers().getAll(HttpHeaders.SET_COOKIE));
                if (this.trailers != null) {
                    this.cookies.addAll(this.trailers.getAll(HttpHeaders.SET_COOKIE));
                }
            }
            return this.cookies;
        }
    }

    private void checkEnded() {
        if (this.trailers != null) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse handler(Handler<Buffer> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.chunkHandler(handler);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse endHandler(Handler<Void> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.endHandler(handler);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.exceptionHandler(handler);
            }
            return this;
        }
    }

    @Override
    public HttpClientResponse pause() {
        this.stream.doPause();
        return this;
    }

    @Override
    public HttpClientResponse resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public HttpClientResponse fetch(long amount) {
        this.stream.doFetch(amount);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.customFrameHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnknownFrame(HttpFrame frame) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.customFrameHandler != null) {
                this.customFrameHandler.handle(frame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChunk(Buffer data) {
        HttpEventHandler handler;
        this.request.dataReceived();
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleChunk(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd(MultiMap trailers) {
        HttpEventHandler handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.trailers = trailers;
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        HttpEventHandler handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers != null) {
                return;
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleException(e);
        } else {
            log.error(e);
        }
    }

    @Override
    public Future<Buffer> body() {
        return this.eventHandler(true).body();
    }

    @Override
    public synchronized Future<Void> end() {
        this.checkEnded();
        return this.eventHandler(true).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.priorityHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.priorityHandler;
        }
        if (handler != null) {
            handler.handle(streamPriority);
        }
    }
}

