/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.impl.ContextInternal;

public class HandlerHolder<T> {
    public final ContextInternal context;
    public final HandlerRegistration<T> handler;
    public final boolean replyHandler;
    public final boolean localOnly;
    private boolean removed;

    public HandlerHolder(HandlerRegistration<T> handler, boolean replyHandler, boolean localOnly, ContextInternal context) {
        this.context = context;
        this.handler = handler;
        this.replyHandler = replyHandler;
        this.localOnly = localOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setRemoved() {
        boolean unregistered = false;
        HandlerHolder handlerHolder = this;
        synchronized (handlerHolder) {
            if (!this.removed) {
                this.removed = true;
                unregistered = true;
            }
        }
        return unregistered;
    }

    public synchronized boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerHolder that = (HandlerHolder)o;
        return !(this.handler != null ? !this.handler.equals(that.handler) : that.handler != null);
    }

    public int hashCode() {
        return this.handler != null ? this.handler.hashCode() : 0;
    }

    public long getSeq() {
        return 0L;
    }

    public ContextInternal getContext() {
        return this.context;
    }

    public HandlerRegistration<T> getHandler() {
        return this.handler;
    }

    public boolean isReplyHandler() {
        return this.replyHandler;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }
}

