/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NoStackTraceTimeoutException;
import io.vertx.core.net.SocketAddress;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    protected final HttpClientImpl client;
    protected final HttpMethod method;
    protected final String uri;
    protected final String path;
    protected final String query;
    protected final String host;
    protected final int port;
    protected final SocketAddress server;
    protected final boolean ssl;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;
    protected final Promise<HttpClientResponse> responsePromise;

    HttpClientRequestBase(HttpClientImpl client, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String uri) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.server = server;
        this.host = host;
        this.port = port;
        this.path = uri.length() > 0 ? HttpUtils.parsePath(uri) : "";
        this.query = HttpUtils.parseQuery(uri);
        this.ssl = ssl;
        this.responsePromise = Promise.promise();
    }

    protected String hostHeader() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.hostHeader() + this.uri;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public String host() {
        return this.server.host();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelTimeout();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    void handleException(Throwable t) {
        this.cancelTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponse resp) {
        long timeoutMS;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            timeoutMS = this.cancelTimeout();
        }
        try {
            this.handleResponse(resp, timeoutMS);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    abstract void handleResponse(HttpClientResponse var1, long var2);

    private synchronized long cancelTimeout() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(long timeoutMs) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            long now;
            long timeSinceLastData;
            if (this.lastDataReceived > 0L && (timeSinceLastData = (now = System.currentTimeMillis()) - this.lastDataReceived) < timeoutMs) {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
                return;
            }
        }
        String msg = "The timeout period of " + timeoutMs + "ms has been exceeded while executing " + (Object)((Object)this.method) + " " + this.uri + " for server " + this.server;
        this.reset(new NoStackTraceTimeoutException(msg));
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public boolean reset(long code) {
        return this.reset(new StreamResetException(code));
    }

    abstract boolean reset(Throwable var1);

    @Override
    public HttpClientRequest setHandler(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.responsePromise.future().setHandler(handler);
        return this;
    }

    @Override
    public boolean isComplete() {
        return this.responsePromise.future().isComplete();
    }

    @Override
    public Handler<AsyncResult<HttpClientResponse>> getHandler() {
        return this.responsePromise.future().getHandler();
    }

    @Override
    public HttpClientResponse result() {
        return this.responsePromise.future().result();
    }

    @Override
    public Throwable cause() {
        return this.responsePromise.future().cause();
    }

    @Override
    public boolean succeeded() {
        return this.responsePromise.future().succeeded();
    }

    @Override
    public boolean failed() {
        return this.responsePromise.future().failed();
    }
}

