/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.WriteStream;

@VertxGen
public interface HttpClientRequest
extends WriteStream<Buffer>,
Future<HttpClientResponse> {
    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> var1);

    public HttpClientRequest setWriteQueueMaxSize(int var1);

    public HttpClientRequest drainHandler(Handler<Void> var1);

    @Fluent
    public HttpClientRequest setFollowRedirects(boolean var1);

    @Fluent
    public HttpClientRequest setMaxRedirects(int var1);

    @Fluent
    public HttpClientRequest setChunked(boolean var1);

    public boolean isChunked();

    public HttpMethod method();

    public String getRawMethod();

    @Fluent
    public HttpClientRequest setRawMethod(String var1);

    public String absoluteURI();

    public String uri();

    public String path();

    public String query();

    @Fluent
    public HttpClientRequest setHost(String var1);

    public String getHost();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpClientRequest putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, Iterable<CharSequence> var2);

    @Override
    public Future<Void> write(String var1);

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> write(String var1, String var2);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public HttpClientRequest continueHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpClientRequest sendHead();

    @Fluent
    public HttpClientRequest sendHead(Handler<HttpVersion> var1);

    @Override
    public Future<Void> end(String var1);

    @Override
    public void end(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> end(String var1, String var2);

    public void end(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public void end(Buffer var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end();

    @Override
    public void end(Handler<AsyncResult<Void>> var1);

    @Fluent
    public HttpClientRequest setTimeout(long var1);

    @Fluent
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> var1);

    default public boolean reset() {
        return this.reset(0L);
    }

    public boolean reset(long var1);

    @CacheReturn
    public HttpConnection connection();

    @Fluent
    public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> var1);

    @Fluent
    public HttpClientRequest writeCustomFrame(int var1, int var2, Buffer var3);

    default public int streamId() {
        return -1;
    }

    @Fluent
    default public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    public StreamPriority getStreamPriority();

    public HttpClientRequest setHandler(Handler<AsyncResult<HttpClientResponse>> var1);
}

