/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.spi.json.JsonCodec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class PemKeyCertOptionsConverter
implements JsonCodec<PemKeyCertOptions, JsonObject> {
    public static final PemKeyCertOptionsConverter INSTANCE = new PemKeyCertOptionsConverter();

    @Override
    public JsonObject encode(PemKeyCertOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public PemKeyCertOptions decode(JsonObject value) {
        return value != null ? new PemKeyCertOptions(value) : null;
    }

    @Override
    public Class<PemKeyCertOptions> getTargetClass() {
        return PemKeyCertOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemKeyCertOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCertPath((String)member.getValue());
                    break;
                }
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setCertPaths(list);
                    break;
                }
                case "certValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCertValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(Base64.getDecoder().decode((String)item))));
                        }
                    });
                    obj.setCertValues(list);
                    break;
                }
                case "keyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyPath((String)member.getValue());
                    break;
                }
                case "keyPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setKeyPaths(list);
                    break;
                }
                case "keyValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "keyValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(Base64.getDecoder().decode((String)item))));
                        }
                    });
                    obj.setKeyValues(list);
                }
            }
        }
    }

    static void toJson(PemKeyCertOptions obj, JsonObject json) {
        PemKeyCertOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PemKeyCertOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add((String)item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("certValues", array);
        }
        if (obj.getKeyPaths() != null) {
            array = new JsonArray();
            obj.getKeyPaths().forEach(item -> array.add((String)item));
            json.put("keyPaths", array);
        }
        if (obj.getKeyValues() != null) {
            array = new JsonArray();
            obj.getKeyValues().forEach(item -> array.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("keyValues", array);
        }
    }
}

