/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;

@VertxGen
public interface DatagramSocket
extends ReadStream<DatagramPacket>,
Measured {
    @Fluent
    public DatagramSocket send(Buffer var1, int var2, String var3, Handler<AsyncResult<Void>> var4);

    default public Future<Void> send(Buffer packet, int port, String host) {
        Promise<Void> promise = Promise.promise();
        this.send(packet, port, host, promise);
        return promise.future();
    }

    public WriteStream<Buffer> sender(int var1, String var2);

    @Fluent
    public DatagramSocket send(String var1, int var2, String var3, Handler<AsyncResult<Void>> var4);

    default public Future<Void> send(String str, int port, String host) {
        Promise<Void> promise = Promise.promise();
        this.send(str, port, host, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket send(String var1, String var2, int var3, String var4, Handler<AsyncResult<Void>> var5);

    default public Future<Void> send(String str, String enc, int port, String host) {
        Promise<Void> promise = Promise.promise();
        this.send(str, enc, port, host, promise);
        return promise.future();
    }

    public void close(Handler<AsyncResult<Void>> var1);

    default public Future<Void> close() {
        Promise<Void> promise = Promise.promise();
        this.close(promise);
        return promise.future();
    }

    @CacheReturn
    public SocketAddress localAddress();

    @Fluent
    public DatagramSocket listenMulticastGroup(String var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> listenMulticastGroup(String multicastAddress) {
        Promise<Void> promise = Promise.promise();
        this.listenMulticastGroup(multicastAddress, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket listenMulticastGroup(String var1, String var2, @Nullable String var3, Handler<AsyncResult<Void>> var4);

    default public Future<Void> listenMulticastGroup(String multicastAddress, String networkInterface, @Nullable String source) {
        Promise<Void> promise = Promise.promise();
        this.listenMulticastGroup(multicastAddress, networkInterface, source, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket unlistenMulticastGroup(String var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> unlistenMulticastGroup(String multicastAddress) {
        Promise<Void> promise = Promise.promise();
        this.unlistenMulticastGroup(multicastAddress, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket unlistenMulticastGroup(String var1, String var2, @Nullable String var3, Handler<AsyncResult<Void>> var4);

    default public Future<Void> unlistenMulticastGroup(String multicastAddress, String networkInterface, @Nullable String source) {
        Promise<Void> promise = Promise.promise();
        this.unlistenMulticastGroup(multicastAddress, networkInterface, source, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket blockMulticastGroup(String var1, String var2, Handler<AsyncResult<Void>> var3);

    default public Future<Void> blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        Promise<Void> promise = Promise.promise();
        this.blockMulticastGroup(multicastAddress, sourceToBlock, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket blockMulticastGroup(String var1, String var2, String var3, Handler<AsyncResult<Void>> var4);

    default public Future<Void> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        Promise<Void> promise = Promise.promise();
        this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, promise);
        return promise.future();
    }

    @Fluent
    public DatagramSocket listen(int var1, String var2, Handler<AsyncResult<DatagramSocket>> var3);

    default public Future<DatagramSocket> listen(int port, String host) {
        Promise<DatagramSocket> promise = Promise.promise();
        this.listen(port, host, promise);
        return promise.future();
    }

    public DatagramSocket pause();

    public DatagramSocket resume();

    public DatagramSocket fetch(long var1);

    public DatagramSocket endHandler(Handler<Void> var1);

    public DatagramSocket handler(Handler<DatagramPacket> var1);

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> var1);
}

