/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;
import java.util.Base64;
import java.util.Map;

public class KeyStoreOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, KeyStoreOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "provider": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setProvider((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(KeyStoreOptions obj, JsonObject json) {
        KeyStoreOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(KeyStoreOptions obj, Map<String, Object> json) {
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getProvider() != null) {
            json.put("provider", obj.getProvider());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType());
        }
        if (obj.getValue() != null) {
            json.put("value", Base64.getEncoder().encodeToString(obj.getValue().getBytes()));
        }
    }
}

