/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.dns.impl.netty.UnixResolverDnsServerAddressStreamProvider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Fix {
    public static final List<String> DEFAULT_SEARCH_DOMAINS;
    private static final int DEFAULT_NDOTS;

    private static List<String> getSearchDomainsHack() throws Exception {
        Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
        Method open = configClass.getMethod("open", new Class[0]);
        Method nameservers = configClass.getMethod("searchlist", new Class[0]);
        Object instance = open.invoke(null, new Object[0]);
        return (List)nameservers.invoke(instance, new Object[0]);
    }

    static {
        int ndots;
        String[] searchDomains;
        try {
            List<String> list = PlatformDependent.isWindows() ? Fix.getSearchDomainsHack() : UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains();
            searchDomains = list.toArray(new String[0]);
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEARCH_DOMAINS = Collections.unmodifiableList(Arrays.asList(searchDomains));
        try {
            ndots = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots();
        }
        catch (Exception ignore) {
            ndots = 1;
        }
        DEFAULT_NDOTS = ndots;
    }
}

