/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.MaxMessagesRecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.logging.LoggingHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramChannelFutureListener;
import io.vertx.core.datagram.impl.DatagramPacketImpl;
import io.vertx.core.datagram.impl.PacketWriteStreamImpl;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.WriteStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Objects;

public class DatagramSocketImpl
implements DatagramSocket,
MetricsProvider {
    private final ContextInternal context;
    private final DatagramSocketMetrics metrics;
    private DatagramChannel channel;
    private Handler<DatagramPacket> packetHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private long demand;

    public static DatagramSocketImpl create(VertxInternal vertx, DatagramSocketOptions options) {
        DatagramSocketImpl socket = new DatagramSocketImpl(vertx, options);
        socket.init();
        return socket;
    }

    private DatagramSocketImpl(VertxInternal vertx, DatagramSocketOptions options) {
        VertxMetrics metrics;
        Transport transport = vertx.transport();
        DatagramChannel channel = transport.datagramChannel(options.isIpV6() ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4);
        transport.configure(channel, new DatagramSocketOptions(options));
        ContextInternal context = vertx.getOrCreateContext();
        if (context.isMultiThreadedWorkerContext()) {
            throw new IllegalStateException("Cannot use DatagramSocket in a multi-threaded worker verticle");
        }
        channel.config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
        MaxMessagesRecvByteBufAllocator bufAllocator = (MaxMessagesRecvByteBufAllocator)channel.config().getRecvByteBufAllocator();
        bufAllocator.maxMessagesPerRead(1);
        context.nettyEventLoop().register((Channel)channel);
        if (options.getLogActivity()) {
            channel.pipeline().addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        this.metrics = (metrics = vertx.metricsSPI()) != null ? metrics.createDatagramSocketMetrics(options) : null;
        this.channel = channel;
        this.context = context;
        this.demand = Long.MAX_VALUE;
    }

    private void init() {
        this.channel.pipeline().addLast("handler", VertxHandler.create(this.context, this::createConnection));
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel.joinGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            this.addListener(this.channel.joinGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel.leaveGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            this.addListener(this.channel.leaveGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = sourceToBlock == null ? null : InetAddress.getByName(sourceToBlock);
            this.addListener(this.channel.block(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel.block(InetAddress.getByName(multicastAddress), InetAddress.getByName(sourceToBlock)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listen(int port, String address, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.listen(new SocketAddressImpl(port, address), handler);
    }

    @Override
    public synchronized DatagramSocket handler(Handler<DatagramPacket> handler) {
        this.packetHandler = handler;
        return this;
    }

    @Override
    public DatagramSocketImpl endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public DatagramSocketImpl exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private DatagramSocket listen(SocketAddress local, Handler<AsyncResult<DatagramSocket>> handler) {
        Objects.requireNonNull(handler, "no null handler accepted");
        this.context.owner().resolveAddress(local.host(), res -> {
            if (res.succeeded()) {
                ChannelFuture future = this.channel.bind((java.net.SocketAddress)new InetSocketAddress((InetAddress)res.result(), local.port()));
                this.addListener(future, ar -> {
                    if (this.metrics != null && ar.succeeded()) {
                        this.metrics.listening(local.host(), this.localAddress());
                    }
                    handler.handle((AsyncResult<DatagramSocket>)ar);
                });
            } else {
                handler.handle(Future.failedFuture(res.cause()));
            }
        });
        return this;
    }

    final void addListener(ChannelFuture future, Handler<AsyncResult<DatagramSocket>> handler) {
        if (handler != null) {
            future.addListener(new DatagramChannelFutureListener<DatagramSocketImpl>(this, handler, this.context));
        }
    }

    @Override
    public synchronized DatagramSocket pause() {
        if (this.demand > 0L) {
            this.demand = 0L;
            this.channel.config().setAutoRead(false);
        }
        return this;
    }

    @Override
    public synchronized DatagramSocket resume() {
        if (this.demand == 0L) {
            this.demand = Long.MAX_VALUE;
            this.channel.config().setAutoRead(true);
        }
        return this;
    }

    @Override
    public synchronized DatagramSocket fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Illegal fetch " + amount);
        }
        if (amount > 0L) {
            if (this.demand == 0L) {
                this.channel.config().setAutoRead(true);
            }
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
        return this;
    }

    @Override
    public DatagramSocket send(Buffer packet, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        Objects.requireNonNull(packet, "no null packet accepted");
        Objects.requireNonNull(host, "no null host accepted");
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.context.owner().resolveAddress(host, res -> {
            if (res.succeeded()) {
                this.doSend(packet, new InetSocketAddress((InetAddress)res.result(), port), handler);
            } else {
                handler.handle(Future.failedFuture(res.cause()));
            }
        });
        if (this.metrics != null) {
            this.metrics.bytesWritten(null, new SocketAddressImpl(port, host), packet.length());
        }
        return this;
    }

    private void doSend(Buffer packet, InetSocketAddress addr, Handler<AsyncResult<DatagramSocket>> handler) {
        ChannelFuture future = this.channel.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(packet.getByteBuf(), addr));
        this.addListener(future, handler);
    }

    @Override
    public WriteStream<Buffer> sender(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        Objects.requireNonNull(host, "no null host accepted");
        return new PacketWriteStreamImpl(this, port, host);
    }

    @Override
    public DatagramSocket send(String str, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(Buffer.buffer(str), port, host, handler);
    }

    @Override
    public DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(Buffer.buffer(str, enc), port, host, handler);
    }

    @Override
    public SocketAddress localAddress() {
        InetSocketAddress addr = this.channel.localAddress();
        return new SocketAddressImpl(addr);
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        if (!this.channel.isOpen()) {
            return;
        }
        this.channel.flush();
        ChannelFuture future = this.channel.close();
        if (handler != null) {
            future.addListener(new DatagramChannelFutureListener<Object>(null, handler, this.context));
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void notifyException(Handler<AsyncResult<DatagramSocket>> handler, Throwable cause) {
        this.context.executeFromIO(v -> handler.handle(Future.failedFuture(cause)));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private Connection createConnection(ChannelHandlerContext chctx) {
        return new Connection(this.context.owner(), chctx, this.context);
    }

    class Connection
    extends ConnectionBase {
        public Connection(VertxInternal vertx, ChannelHandlerContext channel, ContextInternal context) {
            super(vertx, channel, context);
        }

        @Override
        public NetworkMetrics metrics() {
            return DatagramSocketImpl.this.metrics;
        }

        @Override
        protected void handleInterestedOpsChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleException(Throwable t) {
            Handler handler;
            super.handleException(t);
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                handler = DatagramSocketImpl.this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleClosed() {
            DatagramSocketMetrics metrics;
            Handler handler;
            super.handleClosed();
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                handler = DatagramSocketImpl.this.endHandler;
                metrics = DatagramSocketImpl.this.metrics;
            }
            if (metrics != null) {
                metrics.close();
            }
            if (handler != null) {
                handler.handle(null);
            }
        }

        @Override
        public void handleMessage(Object msg) {
            if (msg instanceof io.netty.channel.socket.DatagramPacket) {
                io.netty.channel.socket.DatagramPacket packet = (io.netty.channel.socket.DatagramPacket)msg;
                ByteBuf content = (ByteBuf)packet.content();
                if (content.isDirect()) {
                    content = VertxHandler.safeBuffer(content, this.chctx.alloc());
                }
                this.handlePacket(new DatagramPacketImpl((InetSocketAddress)packet.sender(), Buffer.buffer(content)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handlePacket(DatagramPacket packet) {
            Handler handler;
            DatagramSocketImpl datagramSocketImpl = DatagramSocketImpl.this;
            synchronized (datagramSocketImpl) {
                if (DatagramSocketImpl.this.metrics != null) {
                    DatagramSocketImpl.this.metrics.bytesRead(null, packet.sender(), packet.data().length());
                }
                if (DatagramSocketImpl.this.demand > 0L) {
                    if (DatagramSocketImpl.this.demand != Long.MAX_VALUE) {
                        DatagramSocketImpl.this.demand--;
                    }
                    handler = DatagramSocketImpl.this.packetHandler;
                } else {
                    handler = null;
                }
            }
            if (handler != null) {
                handler.handle(packet);
            }
        }
    }
}

