/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import java.util.UUID;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class WebSocketImplBase<S extends WebSocketBase>
implements WebSocketBase {
    private final boolean supportsContinuation;
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final int maxWebSocketFrameSize;
    private final int maxWebSocketMessageSize;
    private final MessageConsumer binaryHandlerRegistration;
    private final MessageConsumer textHandlerRegistration;
    private String subProtocol;
    private Object metric;
    private Handler<WebSocketFrameInternal> frameHandler;
    private Handler<Buffer> pongHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    protected final Http1xConnectionBase conn;
    protected boolean closed;

    WebSocketImplBase(VertxInternal vertx, Http1xConnectionBase conn, boolean supportsContinuation, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        this.supportsContinuation = supportsContinuation;
        this.textHandlerID = UUID.randomUUID().toString();
        this.binaryHandlerID = UUID.randomUUID().toString();
        this.conn = conn;
        Handler<Message> binaryHandler = msg -> this.writeBinaryFrameInternal((Buffer)msg.body());
        this.binaryHandlerRegistration = vertx.eventBus().localConsumer(this.binaryHandlerID).handler(binaryHandler);
        Handler<Message> textHandler = msg -> this.writeTextFrameInternal((String)msg.body());
        this.textHandlerRegistration = vertx.eventBus().localConsumer(this.textHandlerID).handler(textHandler);
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
        this.maxWebSocketMessageSize = maxWebSocketMessageSize;
    }

    @Override
    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    @Override
    public String textHandlerID() {
        return this.textHandlerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            return this.conn.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.close();
            this.cleanupHandlers();
        }
    }

    @Override
    public void close(short statusCode) {
        this.close(statusCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(short statusCode, String reason) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.closeWithPayload(HttpUtils.generateWSCloseFrameByteBuf(statusCode, reason));
            this.cleanupHandlers();
        }
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    public S writeFinalTextFrame(String text) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true));
    }

    public S writeFinalBinaryFrame(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String subProtocol() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subProtocol(String subProtocol) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.subProtocol = subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeBinaryMessage(Buffer data) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.writeMessageInternal(data);
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeTextMessage(String text) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.writeTextMessageInternal(text);
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S write(Buffer data) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.writeFrame(WebSocketFrame.binaryFrame(data, true));
            return (S)this;
        }
    }

    public S writePing(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            throw new IllegalStateException("Ping cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pingFrame(data));
    }

    public S writePong(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            throw new IllegalStateException("Pong cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pongFrame(data));
    }

    private void writeMessageInternal(Buffer data) {
        this.checkClosed();
        this.writePartialMessage(FrameType.BINARY, data, 0);
    }

    private void writeTextMessageInternal(String text) {
        this.checkClosed();
        Buffer data = Buffer.buffer(text);
        this.writePartialMessage(FrameType.TEXT, data, 0);
    }

    private void writePartialMessage(FrameType frameType, Buffer data, int offset) {
        boolean isFinal;
        int end = offset + this.maxWebSocketFrameSize;
        if (end >= data.length()) {
            end = data.length();
            isFinal = true;
        } else {
            isFinal = false;
        }
        Buffer slice = data.slice(offset, end);
        WebSocketFrame frame = offset == 0 || !this.supportsContinuation ? new WebSocketFrameImpl(frameType, slice.getByteBuf(), isFinal) : WebSocketFrame.continuationFrame(slice, isFinal);
        this.writeFrame(frame);
        int newOffset = offset + this.maxWebSocketFrameSize;
        if (!isFinal) {
            this.writePartialMessage(frameType, data, newOffset);
        }
    }

    private void writeBinaryFrameInternal(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        WebSocketFrameImpl frame = new WebSocketFrameImpl(FrameType.BINARY, buf);
        this.writeFrame(frame);
    }

    private void writeTextFrameInternal(String str) {
        WebSocketFrameImpl frame = new WebSocketFrameImpl(str);
        this.writeFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S writeFrame(WebSocketFrame frame) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.reportBytesWritten(((WebSocketFrameInternal)frame).length());
            this.conn.writeToChannel(frame);
        }
        return (S)this;
    }

    void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFrame(WebSocketFrameInternal frame) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (frame.type() != FrameType.CLOSE) {
                this.conn.reportBytesRead(frame.length());
                if (this.dataHandler != null) {
                    this.dataHandler.handle(frame.binaryData());
                }
            }
            switch (frame.type()) {
                case PONG: {
                    if (this.pongHandler == null) break;
                    this.pongHandler.handle(frame.binaryData());
                    break;
                }
                case TEXT: 
                case CLOSE: 
                case BINARY: 
                case CONTINUATION: {
                    if (this.frameHandler == null) break;
                    this.frameHandler.handle(frame);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S frameHandler(Handler<WebSocketFrame> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.frameHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.frameHandler == null || this.frameHandler.getClass() != FrameAggregator.class) {
                this.frameHandler = new FrameAggregator();
            }
            ((FrameAggregator)this.frameHandler).textMessageHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S binaryMessageHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.frameHandler == null || this.frameHandler.getClass() != FrameAggregator.class) {
                this.frameHandler = new FrameAggregator();
            }
            ((FrameAggregator)this.frameHandler).binaryMessageHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase pongHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.pongHandler = handler;
            return this;
        }
    }

    void writable() {
        if (this.drainHandler != null) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.cleanupHandlers();
            if (this.endHandler != null) {
                this.conn.getContext().runOnContext(this.endHandler);
            }
            if (this.closeHandler != null) {
                this.conn.getContext().runOnContext(this.closeHandler);
            }
        }
    }

    private void cleanupHandlers() {
        if (!this.closed) {
            this.binaryHandlerRegistration.unregister();
            this.textHandlerRegistration.unregister();
            this.closed = true;
        }
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    synchronized Object getMetric() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S handler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.dataHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S endHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.endHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S exceptionHandler(Handler<Throwable> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.exceptionHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S closeHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.closeHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S drainHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.drainHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S pause() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.doPause();
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S resume() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.doResume();
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S setWriteQueueMaxSize(int maxSize) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.doSetWriteQueueMaxSize(maxSize);
            return (S)this;
        }
    }

    @Override
    public void end() {
        this.close();
    }

    private class FrameAggregator
    implements Handler<WebSocketFrameInternal> {
        private Handler<String> textMessageHandler;
        private Handler<Buffer> binaryMessageHandler;
        private Buffer textMessageBuffer;
        private Buffer binaryMessageBuffer;

        private FrameAggregator() {
        }

        @Override
        public void handle(WebSocketFrameInternal frame) {
            switch (frame.type()) {
                case TEXT: {
                    this.handleTextFrame(frame);
                    break;
                }
                case BINARY: {
                    this.handleBinaryFrame(frame);
                    break;
                }
                case CONTINUATION: {
                    if (this.textMessageBuffer != null && this.textMessageBuffer.length() > 0) {
                        this.handleTextFrame(frame);
                        break;
                    }
                    if (this.binaryMessageBuffer == null || this.binaryMessageBuffer.length() <= 0) break;
                    this.handleBinaryFrame(frame);
                }
            }
        }

        private void handleTextFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.textMessageBuffer == null) {
                this.textMessageBuffer = frameBuffer;
            } else {
                this.textMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.textMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.textMessageBuffer.length() - frameBuffer.length();
                this.textMessageBuffer = null;
                String msg = "Cannot process text frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                String fullMessage = this.textMessageBuffer.toString();
                this.textMessageBuffer = null;
                if (this.textMessageHandler != null) {
                    this.textMessageHandler.handle(fullMessage);
                }
            }
        }

        private void handleBinaryFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.binaryMessageBuffer == null) {
                this.binaryMessageBuffer = frameBuffer;
            } else {
                this.binaryMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.binaryMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.binaryMessageBuffer.length() - frameBuffer.length();
                this.binaryMessageBuffer = null;
                String msg = "Cannot process binary frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                Buffer fullMessage = this.binaryMessageBuffer.copy();
                this.binaryMessageBuffer = null;
                if (this.binaryMessageHandler != null) {
                    this.binaryMessageHandler.handle(fullMessage);
                }
            }
        }
    }
}

