/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class HAManager {
    private static final Logger log = LoggerFactory.getLogger(HAManager.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final long QUORUM_CHECK_PERIOD = 1000L;
    private final VertxInternal vertx;
    private final DeploymentManager deploymentManager;
    private final ClusterManager clusterManager;
    private final int quorumSize;
    private final String group;
    private final JsonObject haInfo;
    private final Map<String, String> clusterMap;
    private final String nodeID;
    private final Queue<Runnable> toDeployOnQuorum = new ConcurrentLinkedQueue<Runnable>();
    private final boolean enabled;
    private long quorumTimerID;
    private volatile boolean attainedQuorum;
    private volatile FailoverCompleteHandler failoverCompleteHandler;
    private volatile FailoverCompleteHandler removeSubsHandler;
    private volatile boolean failDuringFailover;
    private volatile boolean stopped;
    private volatile boolean killed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAManager(VertxInternal vertx, ServerID serverID, DeploymentManager deploymentManager, ClusterManager clusterManager, int quorumSize, String group, boolean enabled) {
        this.vertx = vertx;
        this.deploymentManager = deploymentManager;
        this.clusterManager = clusterManager;
        this.quorumSize = enabled ? quorumSize : 0;
        this.group = enabled ? group : "__DISABLED__";
        this.enabled = enabled;
        this.haInfo = new JsonObject();
        this.haInfo.put("verticles", new JsonArray());
        this.haInfo.put("group", this.group);
        this.haInfo.put("server_id", new JsonObject().put("host", serverID.host).put("port", serverID.port));
        this.clusterMap = clusterManager.getSyncMap(CLUSTER_MAP_NAME);
        this.nodeID = clusterManager.getNodeID();
        clusterManager.nodeListener(new NodeListener(){

            @Override
            public void nodeAdded(String nodeID) {
                HAManager.this.nodeAdded(nodeID);
            }

            @Override
            public void nodeLeft(String leftNodeID) {
                HAManager.this.nodeLeft(leftNodeID);
            }
        });
        this.clusterMap.put(this.nodeID, this.haInfo.encode());
        this.quorumTimerID = vertx.setPeriodic(1000L, tid -> this.checkHADeployments());
        HAManager hAManager = this;
        synchronized (hAManager) {
            this.checkQuorum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromHA(String depID) {
        Deployment dep = this.deploymentManager.getDeployment(depID);
        if (dep == null || !dep.deploymentOptions().isHa()) {
            return;
        }
        JsonObject jsonObject = this.haInfo;
        synchronized (jsonObject) {
            JsonArray haMods = this.haInfo.getJsonArray("verticles");
            Iterator<Object> iter = haMods.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                JsonObject mod = (JsonObject)obj;
                if (!mod.getString("dep_id").equals(depID)) continue;
                iter.remove();
            }
            this.clusterMap.put(this.nodeID, this.haInfo.encode());
        }
    }

    public void deployVerticle(String verticleName, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> doneHandler) {
        if (this.attainedQuorum) {
            this.doDeployVerticle(verticleName, deploymentOptions, doneHandler);
        } else {
            log.info("Quorum not attained. Deployment of verticle will be delayed until there's a quorum.");
            this.addToHADeployList(verticleName, deploymentOptions, doneHandler);
        }
    }

    public void stop() {
        if (!this.stopped) {
            if (this.clusterManager.isActive()) {
                this.clusterMap.remove(this.nodeID);
            }
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void simulateKill() {
        if (!this.stopped) {
            this.killed = true;
            this.clusterManager.leave(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to leave cluster", ar.cause());
                }
            });
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void setFailoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        this.failoverCompleteHandler = failoverCompleteHandler;
    }

    public void setRemoveSubsHandler(FailoverCompleteHandler removeSubsHandler) {
        this.removeSubsHandler = removeSubsHandler;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void failDuringFailover(boolean fail) {
        this.failDuringFailover = fail;
    }

    private void doDeployVerticle(String verticleName, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> doneHandler) {
        Handler<AsyncResult<String>> wrappedHandler = asyncResult -> {
            if (asyncResult.succeeded()) {
                this.addToHA((String)asyncResult.result(), verticleName, deploymentOptions);
            }
            if (doneHandler != null) {
                doneHandler.handle((AsyncResult<String>)asyncResult);
            } else if (asyncResult.failed()) {
                log.error((Object)"Failed to deploy verticle", asyncResult.cause());
            }
        };
        this.deploymentManager.deployVerticle(verticleName, deploymentOptions, wrappedHandler);
    }

    private synchronized void nodeAdded(String nodeID) {
        this.checkQuorumWhenAdded(nodeID, System.currentTimeMillis());
    }

    private synchronized void nodeLeft(String leftNodeID) {
        this.checkQuorum();
        if (this.attainedQuorum) {
            String sclusterInfo = this.clusterMap.get(leftNodeID);
            if (sclusterInfo != null) {
                JsonObject clusterInfo = new JsonObject(sclusterInfo);
                this.checkRemoveSubs(leftNodeID, clusterInfo);
                this.checkFailover(leftNodeID, clusterInfo);
            }
            List<String> nodes = this.clusterManager.getNodes();
            for (Map.Entry<String, String> entry : this.clusterMap.entrySet()) {
                if (nodes.contains(entry.getKey())) continue;
                this.checkFailover(entry.getKey(), new JsonObject(entry.getValue()));
            }
        }
    }

    private synchronized void checkQuorumWhenAdded(String nodeID, long start) {
        if (this.clusterMap.containsKey(nodeID)) {
            this.checkQuorum();
        } else {
            this.vertx.setTimer(200L, tid -> this.vertx.executeBlockingInternal(() -> {
                if (System.currentTimeMillis() - start > 10000L) {
                    log.warn("Timed out waiting for group information to appear");
                } else if (!this.stopped) {
                    ContextImpl context = this.vertx.getContext();
                    try {
                        ContextImpl.setContext(null);
                        this.checkQuorumWhenAdded(nodeID, start);
                    }
                    finally {
                        ContextImpl.setContext(context);
                    }
                }
                return null;
            }, null));
        }
    }

    private void checkQuorum() {
        if (this.quorumSize == 0) {
            this.attainedQuorum = true;
        } else {
            boolean attained;
            List<String> nodes = this.clusterManager.getNodes();
            int count = 0;
            for (String node : nodes) {
                JsonObject clusterInfo;
                String group;
                String json = this.clusterMap.get(node);
                if (json == null || !(group = (clusterInfo = new JsonObject(json)).getString("group")).equals(this.group)) continue;
                ++count;
            }
            boolean bl = attained = count >= this.quorumSize;
            if (!this.attainedQuorum && attained) {
                log.info("A quorum has been obtained. Any deploymentIDs waiting on a quorum will now be deployed");
                this.attainedQuorum = true;
            } else if (this.attainedQuorum && !attained) {
                log.info("There is no longer a quorum. Any HA deploymentIDs will be undeployed until a quorum is re-attained");
                this.attainedQuorum = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHA(String deploymentID, String verticleName, DeploymentOptions deploymentOptions) {
        JsonObject jsonObject = this.haInfo;
        synchronized (jsonObject) {
            JsonObject verticleConf = new JsonObject().put("dep_id", deploymentID);
            verticleConf.put("verticle_name", verticleName);
            verticleConf.put("options", deploymentOptions.toJson());
            JsonArray haMods = this.haInfo.getJsonArray("verticles");
            haMods.add(verticleConf);
            String encoded = this.haInfo.encode();
            this.clusterMap.put(this.nodeID, encoded);
        }
    }

    private void addToHADeployList(String verticleName, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> doneHandler) {
        this.toDeployOnQuorum.add(() -> {
            ContextImpl ctx = this.vertx.getContext();
            try {
                ContextImpl.setContext(null);
                this.deployVerticle(verticleName, deploymentOptions, doneHandler);
            }
            finally {
                ContextImpl.setContext(ctx);
            }
        });
    }

    private void checkHADeployments() {
        try {
            if (this.attainedQuorum) {
                this.deployHADeployments();
            } else {
                this.undeployHADeployments();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed when checking HA deploymentIDs", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployHADeployments() {
        for (final String deploymentID : this.deploymentManager.deployments()) {
            final Deployment dep = this.deploymentManager.getDeployment(deploymentID);
            if (dep == null || !dep.deploymentOptions().isHa()) continue;
            ContextImpl ctx = this.vertx.getContext();
            try {
                ContextImpl.setContext(null);
                this.deploymentManager.undeployVerticle(deploymentID, (Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                    @Override
                    public void handle(AsyncResult<Void> result) {
                        if (result.succeeded()) {
                            log.info("Successfully undeployed HA deployment " + deploymentID + "-" + dep.verticleIdentifier() + " as there is no quorum");
                            HAManager.this.addToHADeployList(dep.verticleIdentifier(), dep.deploymentOptions(), new AsyncResultHandler<String>(){

                                @Override
                                public void handle(AsyncResult<String> result) {
                                    if (result.succeeded()) {
                                        log.info("Successfully redeployed verticle " + dep.verticleIdentifier() + " after quorum was re-attained");
                                    } else {
                                        log.error((Object)("Failed to redeploy verticle " + dep.verticleIdentifier() + " after quorum was re-attained"), result.cause());
                                    }
                                }
                            });
                        } else {
                            log.error((Object)"Failed to undeploy deployment on lost quorum", result.cause());
                        }
                    }
                });
            }
            finally {
                ContextImpl.setContext(ctx);
            }
        }
    }

    private void deployHADeployments() {
        int size = this.toDeployOnQuorum.size();
        if (size != 0) {
            Runnable task;
            log.info("There are " + size + " HA deploymentIDs waiting on a quorum. These will now be deployed");
            while ((task = this.toDeployOnQuorum.poll()) != null) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to run redeployment task", t);
                }
            }
        }
    }

    private void checkFailover(String failedNodeID, JsonObject theHAInfo) {
        try {
            JsonArray deployments = theHAInfo.getJsonArray("verticles");
            String group = theHAInfo.getString("group");
            String chosen = this.chooseHashedNode(group, failedNodeID.hashCode());
            if (chosen != null && chosen.equals(this.nodeID)) {
                if (deployments != null && deployments.size() != 0) {
                    log.info("node" + this.nodeID + " says: Node " + failedNodeID + " has failed. This node will deploy " + deployments.size() + " deploymentIDs from that node.");
                    for (Object obj : deployments) {
                        JsonObject app = (JsonObject)obj;
                        this.processFailover(app);
                    }
                }
                this.clusterMap.remove(failedNodeID);
                this.callFailoverCompleteHandler(failedNodeID, theHAInfo, true);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle failover", t);
            this.callFailoverCompleteHandler(failedNodeID, theHAInfo, false);
        }
    }

    private void checkRemoveSubs(String failedNodeID, JsonObject theHAInfo) {
        String chosen = this.chooseHashedNode(null, failedNodeID.hashCode());
        if (chosen != null && chosen.equals(this.nodeID)) {
            this.callFailoverCompleteHandler(this.removeSubsHandler, failedNodeID, theHAInfo, true);
        }
    }

    private void callFailoverCompleteHandler(String nodeID, JsonObject haInfo, boolean result) {
        this.callFailoverCompleteHandler(this.failoverCompleteHandler, nodeID, haInfo, result);
    }

    private void callFailoverCompleteHandler(FailoverCompleteHandler handler, String nodeID, JsonObject haInfo, boolean result) {
        if (handler != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.runOnContext(v -> {
                handler.handle(nodeID, haInfo, result);
                latch.countDown();
            });
            try {
                latch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFailover(JsonObject failedVerticle) {
        if (this.failDuringFailover) {
            throw new VertxException("Oops!");
        }
        String verticleName = failedVerticle.getString("verticle_name");
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference err = new AtomicReference();
        ContextImpl ctx = this.vertx.getContext();
        if (ctx != null) {
            ContextImpl.setContext(null);
        }
        JsonObject options = failedVerticle.getJsonObject("options");
        try {
            this.doDeployVerticle(verticleName, new DeploymentOptions(options), result -> {
                if (result.succeeded()) {
                    log.info("Successfully redeployed verticle " + verticleName + " after failover");
                } else {
                    log.error((Object)"Failed to redeploy verticle after failover", result.cause());
                    err.set(result.cause());
                }
                latch.countDown();
                Throwable t = (Throwable)err.get();
                if (t != null) {
                    throw new VertxException(t);
                }
            });
        }
        finally {
            if (ctx != null) {
                ContextImpl.setContext(ctx);
            }
        }
        try {
            if (!latch.await(120L, TimeUnit.SECONDS)) {
                throw new VertxException("Timed out waiting for redeploy on failover");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String chooseHashedNode(String group, int hashCode) {
        List<String> nodes = this.clusterManager.getNodes();
        ArrayList<String> matchingMembers = new ArrayList<String>();
        for (String node : nodes) {
            String sclusterInfo = this.clusterMap.get(node);
            if (sclusterInfo == null) continue;
            JsonObject clusterInfo = new JsonObject(sclusterInfo);
            String memberGroup = clusterInfo.getString("group");
            if (group != null && !group.equals(memberGroup)) continue;
            matchingMembers.add(node);
        }
        if (!matchingMembers.isEmpty()) {
            long absHash = (long)hashCode + Integer.MAX_VALUE;
            long lpos = absHash % (long)matchingMembers.size();
            return (String)matchingMembers.get((int)lpos);
        }
        return null;
    }
}

