/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import java.util.Objects;

@DataObject
public class VertxOptions {
    public static final int DEFAULT_EVENT_LOOP_POOL_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_WORKER_POOL_SIZE = 20;
    public static final int DEFAULT_INTERNAL_BLOCKING_POOL_SIZE = 20;
    public static final boolean DEFAULT_CLUSTERED = false;
    public static final String DEFAULT_CLUSTER_HOST = "localhost";
    public static final int DEFAULT_CLUSTER_PORT = 0;
    public static final long DEFAULT_CLUSTER_PING_INTERVAL = 20000L;
    public static final long DEFAULT_CLUSTER_PING_REPLY_INTERVAL = 20000L;
    public static final long DEFAULT_BLOCKED_THREAD_CHECK_PERIOD = 1000L;
    public static final long DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME = 2000000000L;
    public static final long DEFAULT_MAX_WORKER_EXECUTE_TIME = 60000000000L;
    public static final int DEFAULT_QUORUM_SIZE = 1;
    public static final String DEFAULT_HA_GROUP = "__DEFAULT__";
    public static final boolean DEFAULT_HA_ENABLED = false;
    public static final boolean DEFAULT_METRICS_ENABLED = false;
    private static final long DEFAULT_WARNING_EXECPTION_TIME = 5000000000L;
    private int eventLoopPoolSize = DEFAULT_EVENT_LOOP_POOL_SIZE;
    private int workerPoolSize = 20;
    private int internalBlockingPoolSize = 20;
    private boolean clustered = false;
    private String clusterHost = "localhost";
    private int clusterPort = 0;
    private long clusterPingInterval = 20000L;
    private long clusterPingReplyInterval = 20000L;
    private long blockedThreadCheckPeriod = 1000L;
    private long maxEventLoopExecuteTime = 2000000000L;
    private long maxWorkerExecuteTime = 60000000000L;
    private ClusterManager clusterManager;
    private boolean haEnabled = false;
    private int quorumSize = 1;
    private String haGroup = "__DEFAULT__";
    private MetricsOptions metrics;
    private long warningExceptionTime = 5000000000L;

    public VertxOptions() {
    }

    public VertxOptions(VertxOptions other) {
        this.eventLoopPoolSize = other.getEventLoopPoolSize();
        this.workerPoolSize = other.getWorkerPoolSize();
        this.clustered = other.isClustered();
        this.clusterHost = other.getClusterHost();
        this.clusterPort = other.getClusterPort();
        this.clusterPingInterval = other.getClusterPingInterval();
        this.clusterPingReplyInterval = other.getClusterPingReplyInterval();
        this.blockedThreadCheckPeriod = other.getBlockedThreadCheckPeriod();
        this.maxEventLoopExecuteTime = other.getMaxEventLoopExecuteTime();
        this.maxWorkerExecuteTime = other.getMaxWorkerExecuteTime();
        this.internalBlockingPoolSize = other.getInternalBlockingPoolSize();
        this.clusterManager = other.getClusterManager();
        this.haEnabled = other.isHAEnabled();
        this.quorumSize = other.getQuorumSize();
        this.haGroup = other.getHAGroup();
        this.metrics = other.getMetricsOptions() != null ? new MetricsOptions(other.getMetricsOptions()) : null;
        this.warningExceptionTime = other.warningExceptionTime;
    }

    public VertxOptions(JsonObject json) {
        this.eventLoopPoolSize = json.getInteger("eventLoopPoolSize", DEFAULT_EVENT_LOOP_POOL_SIZE);
        this.workerPoolSize = json.getInteger("workerPoolSize", 20);
        this.clustered = json.getBoolean("clustered", false);
        this.clusterHost = json.getString("clusterHost", DEFAULT_CLUSTER_HOST);
        this.clusterPort = json.getInteger("clusterPort", 0);
        this.clusterPingInterval = json.getLong("clusterPingInterval", 20000L);
        this.clusterPingReplyInterval = json.getLong("clusterPingReplyInterval", 20000L);
        this.internalBlockingPoolSize = json.getInteger("internalBlockingPoolSize", 20);
        this.blockedThreadCheckPeriod = json.getLong("blockedThreadCheckPeriod", 1000L);
        this.maxEventLoopExecuteTime = json.getLong("maxEventLoopExecuteTime", 2000000000L);
        this.maxWorkerExecuteTime = json.getLong("maxWorkerExecuteTime", 60000000000L);
        this.haEnabled = json.getBoolean("haEnabled", false);
        this.quorumSize = json.getInteger("quorumSize", 1);
        this.haGroup = json.getString("haGroup", DEFAULT_HA_GROUP);
        JsonObject metricsJson = json.getJsonObject("metricsOptions");
        this.metrics = metricsJson != null ? new MetricsOptions(metricsJson) : null;
        this.warningExceptionTime = json.getLong("warningExceptionTime", 5000000000L);
    }

    public int getEventLoopPoolSize() {
        return this.eventLoopPoolSize;
    }

    public VertxOptions setEventLoopPoolSize(int eventLoopPoolSize) {
        if (eventLoopPoolSize < 1) {
            throw new IllegalArgumentException("eventLoopPoolSize must be > 0");
        }
        this.eventLoopPoolSize = eventLoopPoolSize;
        return this;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public VertxOptions setWorkerPoolSize(int workerPoolSize) {
        if (workerPoolSize < 1) {
            throw new IllegalArgumentException("workerPoolSize must be > 0");
        }
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public VertxOptions setClustered(boolean clustered) {
        this.clustered = clustered;
        return this;
    }

    public String getClusterHost() {
        return this.clusterHost;
    }

    public VertxOptions setClusterHost(String clusterHost) {
        this.clusterHost = clusterHost;
        return this;
    }

    public int getClusterPort() {
        return this.clusterPort;
    }

    public VertxOptions setClusterPort(int clusterPort) {
        if (clusterPort < 0 || clusterPort > 65535) {
            throw new IllegalArgumentException("clusterPort p must be in range 0 <= p <= 65535");
        }
        this.clusterPort = clusterPort;
        return this;
    }

    public long getClusterPingInterval() {
        return this.clusterPingInterval;
    }

    public VertxOptions setClusterPingInterval(long clusterPingInterval) {
        if (clusterPingInterval < 1L) {
            throw new IllegalArgumentException("clusterPingInterval must be greater than 0");
        }
        this.clusterPingInterval = clusterPingInterval;
        return this;
    }

    public long getClusterPingReplyInterval() {
        return this.clusterPingReplyInterval;
    }

    public VertxOptions setClusterPingReplyInterval(long clusterPingReplyInterval) {
        if (clusterPingReplyInterval < 1L) {
            throw new IllegalArgumentException("clusterPingReplyInterval must be greater than 0");
        }
        this.clusterPingReplyInterval = clusterPingReplyInterval;
        return this;
    }

    public long getBlockedThreadCheckPeriod() {
        return this.blockedThreadCheckPeriod;
    }

    public VertxOptions setBlockedThreadCheckPeriod(long blockedThreadCheckPeriod) {
        if (blockedThreadCheckPeriod < 1L) {
            throw new IllegalArgumentException("blockedThreadCheckPeriod must be > 0");
        }
        this.blockedThreadCheckPeriod = blockedThreadCheckPeriod;
        return this;
    }

    public long getMaxEventLoopExecuteTime() {
        return this.maxEventLoopExecuteTime;
    }

    public VertxOptions setMaxEventLoopExecuteTime(long maxEventLoopExecuteTime) {
        if (maxEventLoopExecuteTime < 1L) {
            throw new IllegalArgumentException("maxEventLoopExecuteTime must be > 0");
        }
        this.maxEventLoopExecuteTime = maxEventLoopExecuteTime;
        return this;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public VertxOptions setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        if (maxWorkerExecuteTime < 1L) {
            throw new IllegalArgumentException("maxWorkerpExecuteTime must be > 0");
        }
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
        return this;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public VertxOptions setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        return this;
    }

    public int getInternalBlockingPoolSize() {
        return this.internalBlockingPoolSize;
    }

    public VertxOptions setInternalBlockingPoolSize(int internalBlockingPoolSize) {
        if (internalBlockingPoolSize < 1) {
            throw new IllegalArgumentException("internalBlockingPoolSize must be > 0");
        }
        this.internalBlockingPoolSize = internalBlockingPoolSize;
        return this;
    }

    public boolean isHAEnabled() {
        return this.haEnabled;
    }

    public VertxOptions setHAEnabled(boolean haEnabled) {
        this.haEnabled = haEnabled;
        return this;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public VertxOptions setQuorumSize(int quorumSize) {
        if (quorumSize < 1) {
            throw new IllegalArgumentException("quorumSize should be >= 1");
        }
        this.quorumSize = quorumSize;
        return this;
    }

    public String getHAGroup() {
        return this.haGroup;
    }

    public VertxOptions setHAGroup(String haGroup) {
        Objects.requireNonNull(haGroup, "ha group cannot be null");
        this.haGroup = haGroup;
        return this;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metrics;
    }

    public VertxOptions setMetricsOptions(MetricsOptions metrics) {
        this.metrics = metrics;
        return this;
    }

    public long getWarningExceptionTime() {
        return this.warningExceptionTime;
    }

    public VertxOptions setWarningExceptionTime(long warningExceptionTime) {
        if (warningExceptionTime < 1L) {
            throw new IllegalArgumentException("warningExceptionTime must be > 0");
        }
        this.warningExceptionTime = warningExceptionTime;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertxOptions that = (VertxOptions)o;
        if (this.blockedThreadCheckPeriod != that.blockedThreadCheckPeriod) {
            return false;
        }
        if (this.clusterPort != that.clusterPort) {
            return false;
        }
        if (this.clustered != that.clustered) {
            return false;
        }
        if (this.eventLoopPoolSize != that.eventLoopPoolSize) {
            return false;
        }
        if (this.haEnabled != that.haEnabled) {
            return false;
        }
        if (this.internalBlockingPoolSize != that.internalBlockingPoolSize) {
            return false;
        }
        if (this.maxEventLoopExecuteTime != that.maxEventLoopExecuteTime) {
            return false;
        }
        if (this.maxWorkerExecuteTime != that.maxWorkerExecuteTime) {
            return false;
        }
        if (this.quorumSize != that.quorumSize) {
            return false;
        }
        if (this.workerPoolSize != that.workerPoolSize) {
            return false;
        }
        if (this.clusterHost != null ? !this.clusterHost.equals(that.clusterHost) : that.clusterHost != null) {
            return false;
        }
        if (this.clusterManager != null ? !this.clusterManager.equals(that.clusterManager) : that.clusterManager != null) {
            return false;
        }
        if (this.haGroup != null ? !this.haGroup.equals(that.haGroup) : that.haGroup != null) {
            return false;
        }
        return this.warningExceptionTime == that.warningExceptionTime;
    }

    public int hashCode() {
        int result = this.eventLoopPoolSize;
        result = 31 * result + this.workerPoolSize;
        result = 31 * result + this.internalBlockingPoolSize;
        result = 31 * result + (this.clustered ? 1 : 0);
        result = 31 * result + (this.clusterHost != null ? this.clusterHost.hashCode() : 0);
        result = 31 * result + this.clusterPort;
        result = 31 * result + (int)(this.blockedThreadCheckPeriod ^ this.blockedThreadCheckPeriod >>> 32);
        result = 31 * result + (int)(this.maxEventLoopExecuteTime ^ this.maxEventLoopExecuteTime >>> 32);
        result = 31 * result + (int)(this.maxWorkerExecuteTime ^ this.maxWorkerExecuteTime >>> 32);
        result = 31 * result + (this.clusterManager != null ? this.clusterManager.hashCode() : 0);
        result = 31 * result + (this.haEnabled ? 1 : 0);
        result = 31 * result + this.quorumSize;
        result = 31 * result + (this.haGroup != null ? this.haGroup.hashCode() : 0);
        result = 31 * result + (int)(this.warningExceptionTime ^ this.warningExceptionTime >>> 32);
        return result;
    }
}

