/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class DeploymentOptions {
    public static final boolean DEFAULT_WORKER = false;
    public static final boolean DEFAULT_MULTI_THREADED = false;
    public static final String DEFAULT_ISOLATION_GROUP = null;
    public static final boolean DEFAULT_HA = false;
    public static final int DEFAULT_INSTANCES = 1;
    public static final boolean DEFAULT_REDEPLOY = false;
    public static final long DEFAULT_REDEPLOY_SCAN_PERIOD = 250L;
    public static final long DEFAULT_REDEPLOY_GRACE_PERIOD = 1000L;
    private JsonObject config;
    private boolean worker;
    private boolean multiThreaded;
    private String isolationGroup;
    private boolean ha;
    private List<String> extraClasspath;
    private int instances;
    private boolean redeploy;
    private long redeployScanPeriod;
    private long redeployGracePeriod;

    public DeploymentOptions() {
        this.worker = false;
        this.config = null;
        this.multiThreaded = false;
        this.isolationGroup = DEFAULT_ISOLATION_GROUP;
        this.ha = false;
        this.instances = 1;
        this.redeploy = false;
        this.redeployScanPeriod = 250L;
        this.redeployGracePeriod = 1000L;
    }

    public DeploymentOptions(DeploymentOptions other) {
        this.config = other.getConfig() == null ? null : other.getConfig().copy();
        this.worker = other.isWorker();
        this.multiThreaded = other.isMultiThreaded();
        this.isolationGroup = other.getIsolationGroup();
        this.ha = other.isHa();
        this.extraClasspath = other.getExtraClasspath() == null ? null : new ArrayList<String>(other.getExtraClasspath());
        this.instances = other.instances;
        this.redeploy = other.redeploy;
        this.redeployScanPeriod = other.redeployScanPeriod;
        this.redeployGracePeriod = other.redeployGracePeriod;
    }

    public DeploymentOptions(JsonObject json) {
        this.fromJson(json);
    }

    public void fromJson(JsonObject json) {
        this.config = json.getJsonObject("config");
        this.worker = json.getBoolean("worker", false);
        this.multiThreaded = json.getBoolean("multiThreaded", false);
        this.isolationGroup = json.getString("isolationGroup", DEFAULT_ISOLATION_GROUP);
        this.ha = json.getBoolean("ha", false);
        JsonArray arr = json.getJsonArray("extraClasspath", null);
        if (arr != null) {
            this.extraClasspath = arr.getList();
        }
        this.instances = json.getInteger("instances", 1);
        this.redeploy = json.getBoolean("redeploy", false);
        this.redeployScanPeriod = json.getLong("redeployScanPeriod", 250L);
        this.redeployGracePeriod = json.getLong("redeployGracePeriod", 1000L);
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public DeploymentOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public boolean isWorker() {
        return this.worker;
    }

    public DeploymentOptions setWorker(boolean worker) {
        this.worker = worker;
        return this;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public DeploymentOptions setMultiThreaded(boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
        return this;
    }

    public String getIsolationGroup() {
        return this.isolationGroup;
    }

    public DeploymentOptions setIsolationGroup(String isolationGroup) {
        this.isolationGroup = isolationGroup;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.worker) {
            json.put("worker", true);
        }
        if (this.multiThreaded) {
            json.put("multiThreaded", true);
        }
        if (this.isolationGroup != null) {
            json.put("isolationGroup", this.isolationGroup);
        }
        if (this.ha) {
            json.put("ha", true);
        }
        if (this.config != null) {
            json.put("config", this.config);
        }
        if (this.extraClasspath != null) {
            json.put("extraClasspath", new JsonArray(this.extraClasspath));
        }
        if (this.instances != 1) {
            json.put("instances", this.instances);
        }
        if (this.redeploy) {
            json.put("redeploy", this.redeploy);
        }
        if (this.redeployScanPeriod != 250L) {
            json.put("redeployScanPeriod", this.redeployScanPeriod);
        }
        if (this.redeployGracePeriod != 1000L) {
            json.put("redeployGracePeriod", this.redeployGracePeriod);
        }
        return json;
    }

    public boolean isHa() {
        return this.ha;
    }

    public DeploymentOptions setHa(boolean ha) {
        this.ha = ha;
        return this;
    }

    public List<String> getExtraClasspath() {
        return this.extraClasspath;
    }

    public DeploymentOptions setExtraClasspath(List<String> extraClasspath) {
        this.extraClasspath = extraClasspath;
        return this;
    }

    public int getInstances() {
        return this.instances;
    }

    public DeploymentOptions setInstances(int instances) {
        this.instances = instances;
        return this;
    }

    public boolean isRedeploy() {
        return this.redeploy;
    }

    public DeploymentOptions setRedeploy(boolean redeploy) {
        this.redeploy = redeploy;
        return this;
    }

    public long getRedeployScanPeriod() {
        return this.redeployScanPeriod;
    }

    public DeploymentOptions setRedeployScanPeriod(long redeployScanPeriod) {
        if (redeployScanPeriod < 1L) {
            throw new IllegalArgumentException("redeployScanPeriod must be > 0");
        }
        this.redeployScanPeriod = redeployScanPeriod;
        return this;
    }

    public long getRedeployGracePeriod() {
        return this.redeployGracePeriod;
    }

    public DeploymentOptions setRedeployGracePeriod(long redeployGracePeriod) {
        if (redeployGracePeriod < 1L) {
            throw new IllegalArgumentException("redeployGracePeriod must be > 0");
        }
        this.redeployGracePeriod = redeployGracePeriod;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentOptions that = (DeploymentOptions)o;
        if (this.ha != that.ha) {
            return false;
        }
        if (this.multiThreaded != that.multiThreaded) {
            return false;
        }
        if (this.worker != that.worker) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.extraClasspath != null ? !this.extraClasspath.equals(that.extraClasspath) : that.extraClasspath != null) {
            return false;
        }
        if (this.isolationGroup != null ? !this.isolationGroup.equals(that.isolationGroup) : that.isolationGroup != null) {
            return false;
        }
        if (this.instances != that.instances) {
            return false;
        }
        if (this.redeploy != that.redeploy) {
            return false;
        }
        if (this.redeployScanPeriod != that.redeployScanPeriod) {
            return false;
        }
        return this.redeployGracePeriod == that.redeployGracePeriod;
    }

    public int hashCode() {
        int result = this.config != null ? this.config.hashCode() : 0;
        result = 31 * result + (this.worker ? 1 : 0);
        result = 31 * result + (this.multiThreaded ? 1 : 0);
        result = 31 * result + (this.isolationGroup != null ? this.isolationGroup.hashCode() : 0);
        result = 31 * result + (this.ha ? 1 : 0);
        result = 31 * result + (this.extraClasspath != null ? this.extraClasspath.hashCode() : 0);
        result = 31 * result + this.instances;
        result = 31 * result + (this.redeploy ? 1 : 0);
        result = 31 * result + (int)(this.redeployScanPeriod ^ this.redeployScanPeriod >>> 32);
        result = 31 * result + (int)(this.redeployGracePeriod ^ this.redeployGracePeriod >>> 32);
        return result;
    }
}

