/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustStoreOptions;

@Options
public class NetServerOptions
extends TCPSSLOptions {
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_ACCEPT_BACKLOG = 1024;
    public static final boolean DEFAULT_CLIENT_AUTH_REQUIRED = false;
    private int port;
    private String host;
    private int acceptBacklog;
    private boolean clientAuthRequired;

    public NetServerOptions(NetServerOptions other) {
        super(other);
        this.port = other.getPort();
        this.host = other.getHost();
        this.acceptBacklog = other.getAcceptBacklog();
        this.clientAuthRequired = other.isClientAuthRequired();
    }

    public NetServerOptions(JsonObject json) {
        super(json);
        this.port = json.getInteger("port", 0);
        this.host = json.getString("host", DEFAULT_HOST);
        this.acceptBacklog = json.getInteger("acceptBacklog", 1024);
        this.clientAuthRequired = json.getBoolean("clientAuthRequired", false);
    }

    public NetServerOptions() {
        this.port = 0;
        this.host = DEFAULT_HOST;
        this.acceptBacklog = 1024;
        this.clientAuthRequired = false;
    }

    @Override
    public NetServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public NetServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetServerOptions setKeyStoreOptions(KeyStoreOptions keyStore) {
        super.setKeyStoreOptions(keyStore);
        return this;
    }

    @Override
    public NetServerOptions setTrustStoreOptions(TrustStoreOptions trustStore) {
        super.setTrustStoreOptions(trustStore);
        return this;
    }

    @Override
    public NetServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public NetServerOptions setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetServerOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port p must be in range 0 <= p <= 65535");
        }
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public NetServerOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public boolean isClientAuthRequired() {
        return this.clientAuthRequired;
    }

    public NetServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        this.clientAuthRequired = clientAuthRequired;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetServerOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetServerOptions that = (NetServerOptions)o;
        if (this.acceptBacklog != that.acceptBacklog) {
            return false;
        }
        if (this.clientAuthRequired != that.clientAuthRequired) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.acceptBacklog;
        result = 31 * result + (this.clientAuthRequired ? 1 : 0);
        return result;
    }
}

