/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.datagram.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.datagram.DatagramPacket;
import org.vertx.java.core.datagram.DatagramSocket;
import org.vertx.java.core.datagram.InternetProtocolFamily;
import org.vertx.java.core.datagram.impl.DatagramChannelFutureListener;
import org.vertx.java.core.datagram.impl.DatagramServerHandler;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;

public class DefaultDatagramSocket
extends ConnectionBase
implements DatagramSocket {
    private Handler<Void> drainHandler;
    protected boolean configurable = true;
    private Handler<DatagramPacket> dataHandler;

    public DefaultDatagramSocket(VertxInternal vertx, InternetProtocolFamily family) {
        super(vertx, (Channel)DefaultDatagramSocket.createChannel(family), vertx.getOrCreateContext());
        this.channel().config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
        this.context.getEventLoop().register(this.channel);
        this.channel.pipeline().addLast("handler", (ChannelHandler)new DatagramServerHandler(this.vertx, this));
        this.channel().config().setMaxMessagesPerRead(1);
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().joinGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().joinGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), InetAddress.getByName(source)), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().leaveGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().leaveGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), InetAddress.getByName(source)), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().block(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), InetAddress.getByName(sourceToBlock)), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        try {
            this.addListener(this.channel().block(InetAddress.getByName(multicastAddress), InetAddress.getByName(sourceToBlock)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listen(String address, int port, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        return this.listen(new InetSocketAddress(address, port), handler);
    }

    @Override
    public DatagramSocket listen(int port, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        return this.listen(new InetSocketAddress(port), handler);
    }

    @Override
    public DatagramSocket listen(InetSocketAddress local, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        ChannelFuture future = this.channel().bind((SocketAddress)local);
        this.addListener(future, handler);
        return this;
    }

    @Override
    public DatagramSocket dataHandler(Handler<DatagramPacket> handler) {
        this.dataHandler = handler;
        return this;
    }

    final void handleMessage(DatagramPacket message) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(message);
        }
    }

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private void checkConfigurable() {
        if (!this.configurable) {
            throw new IllegalStateException("Can't set property after connect or bind has been called");
        }
    }

    final void addListener(ChannelFuture future, Handler<AsyncResult<DatagramSocket>> handler) {
        if (handler != null) {
            future.addListener(new DatagramChannelFutureListener<DefaultDatagramSocket>(this, handler, this.vertx, this.context));
        }
    }

    @Override
    public DatagramSocket pause() {
        this.doPause();
        return this;
    }

    @Override
    public DatagramSocket resume() {
        this.doResume();
        return this;
    }

    @Override
    protected void handleInterestedOpsChanged() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    @Override
    public DatagramSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.doWriteQueueFull();
    }

    @Override
    public DatagramSocket drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public DatagramSocket send(Buffer packet, String host, int port, Handler<AsyncResult<DatagramSocket>> handler) {
        this.configurable = false;
        ChannelFuture future = this.channel().writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(packet.getByteBuf(), new InetSocketAddress(host, port)));
        this.addListener(future, handler);
        return this;
    }

    @Override
    public DatagramSocket send(String str, String host, int port, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(new Buffer(str), host, port, handler);
    }

    @Override
    public DatagramSocket send(String str, String enc, String host, int port, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(new Buffer(str, enc), host, port, handler);
    }

    @Override
    public int getSendBufferSize() {
        return this.channel().config().getSendBufferSize();
    }

    @Override
    public DatagramSocket setSendBufferSize(int sendBufferSize) {
        this.checkConfigurable();
        this.channel().config().setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.channel().config().getReceiveBufferSize();
    }

    @Override
    public DatagramSocket setReceiveBufferSize(int receiveBufferSize) {
        this.checkConfigurable();
        this.channel().config().setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public int getTrafficClass() {
        return this.channel().config().getTrafficClass();
    }

    @Override
    public DatagramSocket setTrafficClass(int trafficClass) {
        this.checkConfigurable();
        this.channel().config().setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public boolean isReuseAddress() {
        return this.channel().config().isReuseAddress();
    }

    @Override
    public DatagramSocket setReuseAddress(boolean reuseAddress) {
        this.checkConfigurable();
        this.channel().config().setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public boolean isBroadcast() {
        return this.channel().config().isBroadcast();
    }

    @Override
    public DatagramSocket setBroadcast(boolean broadcast) {
        this.checkConfigurable();
        this.channel().config().setBroadcast(broadcast);
        return this;
    }

    @Override
    public boolean isMulticastLoopbackMode() {
        return this.channel().config().isLoopbackModeDisabled();
    }

    @Override
    public DatagramSocket setMulticastLoopbackMode(boolean loopbackModeDisabled) {
        this.checkConfigurable();
        this.channel().config().setLoopbackModeDisabled(loopbackModeDisabled);
        return this;
    }

    @Override
    public int getMulticastTimeToLive() {
        return this.channel().config().getTimeToLive();
    }

    @Override
    public DatagramSocket setMulticastTimeToLive(int ttl) {
        this.checkConfigurable();
        this.channel().config().setTimeToLive(ttl);
        return this;
    }

    @Override
    public String getMulticastNetworkInterface() {
        NetworkInterface iface = this.channel().config().getNetworkInterface();
        if (iface == null) {
            return null;
        }
        return iface.getName();
    }

    @Override
    public DatagramSocket setMulticastNetworkInterface(String iface) {
        this.checkConfigurable();
        try {
            this.channel().config().setNetworkInterface(NetworkInterface.getByName(iface));
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Could not find network interface with name " + iface, e);
        }
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.endReadAndFlush();
        ChannelFuture future = this.channel.close();
        if (handler != null) {
            future.addListener(new DatagramChannelFutureListener<Object>(null, handler, this.vertx, this.context));
        }
    }

    protected DatagramChannel channel() {
        return (DatagramChannel)this.channel;
    }

    private static NioDatagramChannel createChannel(InternetProtocolFamily family) {
        if (family == null) {
            return new NioDatagramChannel();
        }
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(io.netty.channel.socket.InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(io.netty.channel.socket.InternetProtocolFamily.IPv6);
            }
        }
        return new NioDatagramChannel();
    }

    private void notifyException(final Handler<AsyncResult<DatagramSocket>> handler, final Throwable cause) {
        if (this.context.isOnCorrectWorker(this.channel().eventLoop())) {
            try {
                this.vertx.setContext(this.context);
                handler.handle(new DefaultFutureResult<Throwable>(cause));
            }
            catch (Throwable t) {
                this.context.reportException(t);
            }
        } else {
            this.context.execute(new Runnable(){

                @Override
                public void run() {
                    handler.handle(new DefaultFutureResult<Throwable>(cause));
                }
            });
        }
    }
}

