/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.impl.ServerIDs;
import org.vertx.java.core.eventbus.impl.SubsMap;
import org.vertx.java.core.eventbus.impl.hazelcast.HazelcastServerID;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.ServerID;

public class HazelcastSubsMap
implements SubsMap,
EntryListener<String, HazelcastServerID> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastSubsMap.class);
    private final VertxInternal vertx;
    private final MultiMap<String, HazelcastServerID> map;
    private ConcurrentMap<String, ServerIDs> cache = new ConcurrentHashMap<String, ServerIDs>();

    public HazelcastSubsMap(VertxInternal vertx, MultiMap<String, HazelcastServerID> map) {
        this.vertx = vertx;
        this.map = map;
        map.addEntryListener((EntryListener)this, true);
    }

    @Override
    public void removeAllForServerID(final ServerID serverID, Handler<AsyncResult<Void>> completionHandler) {
        new BlockingAction<Void>(this.vertx, completionHandler){

            @Override
            public Void action() {
                for (Map.Entry entry : HazelcastSubsMap.this.map.entrySet()) {
                    HazelcastServerID hid = (HazelcastServerID)entry.getValue();
                    if (!hid.serverID.equals(serverID)) continue;
                    HazelcastSubsMap.this.map.remove(entry.getKey(), (Object)hid);
                }
                return null;
            }
        }.run();
    }

    @Override
    public void put(final String subName, final ServerID serverID, Handler<AsyncResult<Void>> completionHandler) {
        new BlockingAction<Void>(this.vertx, completionHandler){

            @Override
            public Void action() {
                HazelcastSubsMap.this.map.put((Object)subName, (Object)new HazelcastServerID(serverID));
                return null;
            }
        }.run();
    }

    @Override
    public void get(final String subName, final Handler<AsyncResult<ServerIDs>> completionHandler) {
        ServerIDs entries = (ServerIDs)this.cache.get(subName);
        DefaultFutureResult result = new DefaultFutureResult();
        if (entries != null && entries.isInitialised()) {
            ((DefaultFutureResult)result.setResult(entries)).setHandler(completionHandler);
        } else {
            new BlockingAction<Collection<HazelcastServerID>>(this.vertx, (Handler)new AsyncResultHandler<Collection<HazelcastServerID>>(){

                @Override
                public void handle(AsyncResult<Collection<HazelcastServerID>> result) {
                    DefaultFutureResult sresult = new DefaultFutureResult();
                    if (result.succeeded()) {
                        ServerIDs prev;
                        ServerIDs sids;
                        Collection<HazelcastServerID> entries = result.result();
                        if (entries != null) {
                            sids = new ServerIDs(entries.size());
                            for (HazelcastServerID hid : entries) {
                                sids.add(hid.serverID);
                            }
                        } else {
                            sids = new ServerIDs(0);
                        }
                        if ((prev = HazelcastSubsMap.this.cache.putIfAbsent(subName, sids)) != null) {
                            prev.merge(sids);
                            sids = prev;
                        }
                        sids.setInitialised();
                        sresult.setResult(sids);
                    } else {
                        sresult.setFailure(result.cause());
                    }
                    sresult.setHandler(completionHandler);
                }
            }){

                @Override
                public Collection<HazelcastServerID> action() {
                    return HazelcastSubsMap.this.map.get((Object)subName);
                }
            }.run();
        }
    }

    @Override
    public void remove(final String subName, final ServerID serverID, Handler<AsyncResult<Void>> completionHandler) {
        new BlockingAction<Void>(this.vertx, completionHandler){

            @Override
            public Void action() {
                HazelcastSubsMap.this.map.remove((Object)subName, (Object)new HazelcastServerID(serverID));
                return null;
            }
        }.run();
    }

    public void entryAdded(EntryEvent<String, HazelcastServerID> entry) {
        this.addEntry((String)entry.getKey(), ((HazelcastServerID)entry.getValue()).serverID);
    }

    private void addEntry(String key, ServerID value) {
        ServerIDs prev;
        ServerIDs entries = (ServerIDs)this.cache.get(key);
        if (entries == null && (prev = this.cache.putIfAbsent(key, entries = new ServerIDs(1))) != null) {
            entries = prev;
        }
        entries.add(value);
    }

    public void entryRemoved(EntryEvent<String, HazelcastServerID> entry) {
        this.removeEntry((String)entry.getKey(), ((HazelcastServerID)entry.getValue()).serverID);
    }

    private void removeEntry(String key, ServerID value) {
        ServerIDs entries = (ServerIDs)this.cache.get(key);
        if (entries != null) {
            entries.remove(value);
            if (entries.isEmpty()) {
                this.cache.remove(key);
            }
        }
    }

    public void entryUpdated(EntryEvent<String, HazelcastServerID> entry) {
        String key = (String)entry.getKey();
        ServerIDs entries = (ServerIDs)this.cache.get(key);
        if (entries != null) {
            entries.add(((HazelcastServerID)entry.getValue()).serverID);
        }
    }

    public void entryEvicted(EntryEvent<String, HazelcastServerID> entry) {
        this.entryRemoved(entry);
    }
}

