/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws;

import io.netty.buffer.BufUtil;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;

@ChannelHandler.Sharable
public class WebSocketConvertHandler
extends MessageToMessageCodec<io.netty.handler.codec.http.websocketx.WebSocketFrame, WebSocketFrame> {
    public static final WebSocketConvertHandler INSTANCE = new WebSocketConvertHandler();

    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, MessageBuf<Object> out) throws Exception {
        BufUtil.retain((Object)msg);
        switch (msg.getType()) {
            case BINARY: {
                out.add((Object)new BinaryWebSocketFrame(msg.getBinaryData()));
                return;
            }
            case TEXT: {
                out.add((Object)new TextWebSocketFrame(msg.getBinaryData()));
                return;
            }
            case CLOSE: {
                out.add((Object)new CloseWebSocketFrame(true, 0, msg.getBinaryData()));
                return;
            }
            case CONTINUATION: {
                out.add((Object)new ContinuationWebSocketFrame(msg.getBinaryData()));
                return;
            }
            case PONG: {
                out.add((Object)new PongWebSocketFrame(msg.getBinaryData()));
                return;
            }
            case PING: {
                out.add((Object)new PingWebSocketFrame(msg.getBinaryData()));
                return;
            }
        }
        throw new IllegalStateException("Unsupported websocket msg " + msg);
    }

    protected void decode(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg, MessageBuf<Object> out) throws Exception {
        if (msg instanceof BinaryWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.BINARY, msg.content().retain()));
            return;
        }
        if (msg instanceof CloseWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.CLOSE, msg.content().retain()));
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.PING, msg.content().retain()));
            return;
        }
        if (msg instanceof PongWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.PONG, msg.content().retain()));
            return;
        }
        if (msg instanceof TextWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.TEXT, msg.content().retain()));
            return;
        }
        if (msg instanceof ContinuationWebSocketFrame) {
            out.add((Object)new DefaultWebSocketFrame(WebSocketFrame.FrameType.CONTINUATION, msg.content().retain()));
            return;
        }
        throw new IllegalStateException("Unsupported websocket msg " + msg);
    }
}

