/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class BufferMessage
extends BaseMessage<Buffer> {
    private static final Logger log = LoggerFactory.getLogger(BufferMessage.class);

    BufferMessage(boolean send, String address, Buffer body) {
        super(send, address, body);
    }

    public BufferMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            int buffLength = readBuff.getInt(++pos);
            byte[] bytes = readBuff.getBytes(pos += 4, pos + buffLength);
            this.body = new Buffer(bytes);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt(((Buffer)this.body).length());
            buff.appendBuffer((Buffer)this.body);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 4 + ((Buffer)this.body).length());
    }

    @Override
    protected Message<Buffer> copy() {
        BufferMessage copied = new BufferMessage(this.send, this.address, this.body == null ? null : ((Buffer)this.body).copy());
        copied.replyAddress = this.replyAddress;
        copied.bus = this.bus;
        copied.sender = this.sender;
        return copied;
    }

    @Override
    protected byte type() {
        return 1;
    }
}

