/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.impl.DefaultAsyncFile;
import org.vertx.java.core.file.impl.DefaultFileSystem;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class WindowsFileSystem
extends DefaultFileSystem {
    private static final Logger log = LoggerFactory.getLogger(WindowsFileSystem.class);

    public WindowsFileSystem(VertxInternal vertx) {
        super(vertx);
    }

    private void logInternal(String perms) {
        if (perms != null && log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file permissions are not supported");
        }
    }

    @Override
    protected BlockingAction<Void> chmodInternal(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.logInternal(perms);
        this.logInternal(dirPerms);
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                return null;
            }
        };
    }

    @Override
    protected BlockingAction<Void> mkdirInternal(String path, String perms, boolean createParents, Handler<AsyncResult<Void>> handler) {
        this.logInternal(perms);
        return super.mkdirInternal(path, null, createParents, handler);
    }

    @Override
    protected AsyncFile doOpen(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, DefaultContext context) {
        this.logInternal(perms);
        return new DefaultAsyncFile(this.vertx, path, null, read, write, createNew, flush, context);
    }

    @Override
    protected BlockingAction<Void> createFileInternal(String p, String perms, Handler<AsyncResult<Void>> handler) {
        this.logInternal(perms);
        return super.createFileInternal(p, null, handler);
    }
}

