/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import io.netty.util.CharsetUtil;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class StringMessage
extends BaseMessage<String> {
    private static final Logger log = LoggerFactory.getLogger(StringMessage.class);
    private byte[] encoded;

    StringMessage(boolean send, String address, String body) {
        super(send, address, body);
    }

    public StringMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            int strLength = readBuff.getInt(++pos);
            byte[] bytes = readBuff.getBytes(pos += 4, pos + strLength);
            this.body = new String(bytes, CharsetUtil.UTF_8);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt(this.encoded.length);
            buff.appendBytes(this.encoded);
        }
        this.encoded = null;
    }

    @Override
    protected int getBodyLength() {
        if (this.body == null) {
            return 1;
        }
        this.encoded = ((String)this.body).getBytes(CharsetUtil.UTF_8);
        return 5 + this.encoded.length;
    }

    @Override
    protected Message<String> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 11;
    }
}

