/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.core.net.impl.ServerID;

public class ServerIDs
implements Iterable<ServerID> {
    private volatile boolean initialised;
    private final Set<ServerID> ids;
    private volatile Iterator<ServerID> iter;

    public ServerIDs(int initialSize) {
        this.ids = new ConcurrentHashSet<ServerID>(initialSize);
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void setInitialised() {
        this.initialised = true;
    }

    public void add(ServerID id) {
        this.ids.add(id);
    }

    public void remove(ServerID id) {
        this.ids.remove(id);
    }

    public void merge(ServerIDs toMerge) {
        this.ids.addAll(toMerge.ids);
    }

    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    @Override
    public Iterator<ServerID> iterator() {
        return this.ids.iterator();
    }

    public synchronized ServerID choose() {
        if (!this.ids.isEmpty()) {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.ids.iterator();
            }
            try {
                return this.iter.next();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return null;
    }
}

