/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class IntMessage
extends BaseMessage<Integer> {
    private static final Logger log = LoggerFactory.getLogger(IntMessage.class);

    IntMessage(boolean send, String address, Integer body) {
        super(send, address, body);
    }

    public IntMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = readBuff.getInt(++pos);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt((Integer)this.body);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 4);
    }

    @Override
    protected Message<Integer> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 8;
    }
}

