/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.impl.Utils;

class EventParser {
    private static final String ID_KEY = "ID";
    private static final String NAME_KEY = "Name";
    private static final String PAYLOAD_KEY = "Payload";
    private static final String NODE_FILTER_KEY = "NodeFilter";
    private static final String SERVICE_FILTER_KEY = "ServiceFilter";
    private static final String TAG_FILTER_KEY = "TagFilter";
    private static final String VERSION_KEY = "Version";
    private static final String LTIME_KEY = "LTime";

    EventParser() {
    }

    static Event parse(JsonObject json) {
        Event ev = new Event().setId(json.getString(ID_KEY)).setName(json.getString(NAME_KEY)).setNode(json.getString(NODE_FILTER_KEY)).setService(json.getString(SERVICE_FILTER_KEY)).setTag(json.getString(TAG_FILTER_KEY)).setVersion(json.getInteger(VERSION_KEY, Integer.valueOf(0))).setLTime(json.getInteger(LTIME_KEY, Integer.valueOf(0)));
        String payload = json.getString(PAYLOAD_KEY);
        if (payload != null) {
            ev.setPayload(Utils.decode64(payload));
        }
        return ev;
    }
}

