/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.Helper;
import io.vertx.codegen.MapperKind;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.MapperInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeReflectionFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo create(Type type) {
        if (type == Void.TYPE) {
            return VoidTypeInfo.INSTANCE;
        }
        if (type instanceof Class) {
            DataObjectInfo dataObject;
            String fqcn = type.getTypeName();
            Class classType = (Class)type;
            if (classType.isPrimitive()) {
                return PrimitiveTypeInfo.PRIMITIVES.get(classType.getName());
            }
            Package pkg = classType.getPackage();
            ModuleInfo module = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classType.getClassLoader());
            try {
                while (pkg != null) {
                    ModuleGen annotation = pkg.getAnnotation(ModuleGen.class);
                    if (annotation != null) {
                        module = new ModuleInfo(pkg.getName(), annotation.name(), annotation.groupPackage());
                        break;
                    }
                    int pos = pkg.getName().lastIndexOf(46);
                    if (pos == -1) {
                        break;
                    }
                    pkg = Package.getPackage(pkg.getName().substring(0, pos));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (classType.isEnum()) {
                return new EnumTypeInfo(fqcn, classType.getDeclaredAnnotation(VertxGen.class) != null, Stream.of(classType.getEnumConstants()).map(Object::toString).collect(Collectors.toList()), module, false);
            }
            ClassKind kind = ClassKind.getKind(fqcn, classType.getAnnotation(VertxGen.class) != null);
            ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
            int index = 0;
            for (TypeVariable var : classType.getTypeParameters()) {
                typeParams.add(new TypeParamInfo.Class(classType.getName(), index++, var.getName()));
            }
            if (kind == ClassKind.API) {
                TypeVariable classTypeVariable = Handler.class.getTypeParameters()[0];
                Type handlerArg = Helper.resolveTypeParameter(type, classTypeVariable);
                return new ApiTypeInfo(fqcn, true, typeParams, handlerArg != null ? TypeReflectionFactory.create(handlerArg) : null, module, false, false, null);
            }
            if (classType.getDeclaredAnnotation(DataObject.class) != null) {
                MapperInfo serializer = TypeReflectionFactory.getDataObjectSerializer(classType);
                MapperInfo deserializer = TypeReflectionFactory.getDataObjectDeserializer(classType);
                dataObject = new DataObjectInfo(true, serializer, deserializer);
            } else {
                dataObject = null;
            }
            return new ClassTypeInfo(kind, fqcn, module, false, typeParams, dataObject);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            List<TypeInfo> args = Arrays.asList(parameterizedType.getActualTypeArguments()).stream().map(TypeReflectionFactory::create).collect(Collectors.toList());
            Type raw = parameterizedType.getRawType();
            return new ParameterizedTypeInfo((ClassTypeInfo)TypeReflectionFactory.create(raw), false, args);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            TypeParamInfo param = TypeParamInfo.create(typeVar);
            return new TypeVariableInfo(param, false, ((TypeVariable)type).getName());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static MapperInfo getDataObjectSerializer(Class<?> type) {
        try {
            Method m = type.getMethod("toJson", new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && m.getReturnType().equals(JsonObject.class)) {
                MapperInfo serializer = new MapperInfo();
                serializer.setQualifiedName(type.getName());
                serializer.setKind(MapperKind.SELF);
                return serializer;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static MapperInfo getDataObjectDeserializer(Class<?> type) {
        try {
            if (!Modifier.isAbstract(type.getModifiers()) && !type.isInterface() && Modifier.isPublic(type.getConstructor(JsonObject.class).getModifiers())) {
                MapperInfo deserializer = new MapperInfo();
                deserializer.setQualifiedName(type.getName());
                deserializer.setKind(MapperKind.SELF);
                return deserializer;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

