/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.CodeGen;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Model;
import io.vertx.codegen.annotations.GenIgnore;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Helper {
    public static final Function<Element, Stream<ExecutableElement>> FILTER_METHOD = element -> {
        if (element.getKind() == ElementKind.METHOD) {
            return Stream.of((ExecutableElement)element);
        }
        return Stream.empty();
    };
    public static final Function<Element, Stream<VariableElement>> FILTER_FIELD = element -> {
        if (element.getKind() == ElementKind.FIELD) {
            return Stream.of((VariableElement)element);
        }
        return Stream.empty();
    };
    static final Function<Element, Stream<ExecutableElement>> CAST = element -> {
        if (element.getKind() == ElementKind.METHOD) {
            return Stream.of((ExecutableElement)element);
        }
        return Stream.empty();
    };
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("#(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)(?:\\((.*)\\))?$");
    public static final Pattern LINK_REFERENCE_PATTERN = Pattern.compile("(?:(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)?(?:" + SIGNATURE_PATTERN.pattern() + ")?");
    private static final Pattern WHITESPACE_CLUSTER_PATTERN = Pattern.compile("\\s+");

    static <T> Function<Object, Stream<T>> instanceOf(Class<T> type) {
        return o -> {
            if (type.isInstance(o)) {
                return Stream.of(type.cast(o));
            }
            return Stream.empty();
        };
    }

    static <T> Function<Object, Stream<T>> cast(Class<T> type) {
        return o -> Stream.of(type.cast(o));
    }

    public static String normalizePropertyName(String propertyName) {
        if (Character.isUpperCase(propertyName.charAt(0))) {
            StringBuilder buffer = new StringBuilder(propertyName);
            int index = 0;
            do {
                buffer.setCharAt(index, Character.toLowerCase(buffer.charAt(index++)));
            } while (index < buffer.length() && Character.isUpperCase(buffer.charAt(index)) && (index + 1 >= buffer.length() || !Character.isLowerCase(buffer.charAt(index + 1))));
            propertyName = buffer.toString();
        }
        return propertyName;
    }

    public static String decapitaliseFirstLetter(String str) {
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String convertCamelCaseToUnderscores(String str) {
        return str.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z\\d])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String getSimpleName(String type) {
        return type.substring(type.lastIndexOf(46) + 1);
    }

    public static String getPackageName(String type) {
        int index = type.lastIndexOf(46);
        if (index >= 0) {
            return type.substring(0, index);
        }
        return "";
    }

    public static String getNonGenericType(String type) {
        int pos = type.indexOf("<");
        if (pos >= 0) {
            String nonGenericType = type.substring(0, pos);
            return nonGenericType;
        }
        return type;
    }

    public static String indentString(String str, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            sb.append(ch);
            if (ch != '\n' || i == str.length() - 1) continue;
            sb.append(indent);
        }
        return sb.toString();
    }

    public static String getJavadocTag(String comment, String tagName) {
        int pos = comment.indexOf(tagName);
        int endPos = comment.indexOf("\n", pos);
        String tag = comment.substring(pos + tagName.length() + 1, endPos);
        return tag;
    }

    public static String removeTags(String comment) {
        int pos = comment.indexOf(64);
        if (pos == -1) {
            return comment;
        }
        if (pos > 0) {
            String beforePos = comment.substring(0, pos);
            int prevReturn = beforePos.lastIndexOf(10);
            pos = prevReturn != -1 ? prevReturn : 0;
        }
        return comment.substring(0, pos);
    }

    public static AnnotationMirror resolveMethodAnnotation(Class<? extends Annotation> annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method) {
        return Helper.resolveMethodAnnotation((DeclaredType)elementUtils.getTypeElement(annotationType.getName()).asType(), elementUtils, typeUtils, declaring, method);
    }

    public static AnnotationMirror resolveMethodAnnotation(DeclaredType annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method) {
        Optional<AnnotationMirror> annotation = method.getAnnotationMirrors().stream().filter(mirror -> typeUtils.isSameType(mirror.getAnnotationType(), annotationType)).findFirst();
        if (annotation.isPresent()) {
            return annotation.get();
        }
        return Helper.isFluent(annotationType, elementUtils, typeUtils, declaring, method, method.getEnclosingElement().asType());
    }

    private static AnnotationMirror isFluent(DeclaredType annotationType, Elements elementUtils, Types typeUtils, TypeElement declaring, ExecutableElement method, TypeMirror type) {
        for (TypeMirror typeMirror : typeUtils.directSupertypes(type)) {
            Element directSuperTypeElt = typeUtils.asElement(typeMirror);
            if (!(directSuperTypeElt instanceof TypeElement)) continue;
            List methods = ((TypeElement)directSuperTypeElt).getEnclosedElements().stream().filter(member -> member.getKind() == ElementKind.METHOD).map(member -> (ExecutableElement)member).collect(Collectors.toList());
            for (ExecutableElement m : methods) {
                AnnotationMirror annotation;
                if (!elementUtils.overrides(method, m, declaring) || (annotation = Helper.resolveMethodAnnotation(annotationType, elementUtils, typeUtils, (TypeElement)directSuperTypeElt, m)) == null) continue;
                return annotation;
            }
            AnnotationMirror annotation = Helper.isFluent(annotationType, elementUtils, typeUtils, declaring, method, typeMirror);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static TypeMirror resolveTypeParameter(Types typeUtils, DeclaredType subType, TypeParameterElement typeParam) {
        TypeMirror erasedSubType;
        TypeMirror erased = typeUtils.erasure(typeParam.getGenericElement().asType());
        if (typeUtils.isSameType(erased, erasedSubType = typeUtils.erasure(subType))) {
            return typeUtils.asMemberOf(subType, ((javax.lang.model.type.TypeVariable)typeParam.asType()).asElement());
        }
        if (typeUtils.isSubtype(erasedSubType, erased)) {
            for (TypeMirror typeMirror : typeUtils.directSupertypes(subType)) {
                TypeMirror resolved = Helper.resolveTypeParameter(typeUtils, (DeclaredType)typeMirror, typeParam);
                if (resolved == null) continue;
                return resolved;
            }
        }
        return null;
    }

    public static <T> Type resolveTypeParameter(Type type, TypeVariable<Class<T>> typeParam) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (Stream.of(classType.getTypeParameters()).filter(tp -> tp.equals(typeParam)).findFirst().isPresent()) {
                return typeParam;
            }
            ArrayList<Type> superTypes = new ArrayList<Type>();
            if (classType.getGenericSuperclass() != null) {
                superTypes.add(classType.getGenericSuperclass());
            }
            Collections.addAll(superTypes, classType.getGenericInterfaces());
            for (Type superType : superTypes) {
                Type resolved = Helper.resolveTypeParameter(superType, typeParam);
                if (resolved == null) continue;
                return resolved;
            }
        } else if (type instanceof ParameterizedType) {
            Object owner;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type resolvedType = Helper.resolveTypeParameter(rawType, typeParam);
            if (resolvedType instanceof TypeVariable && (owner = ((TypeVariable)resolvedType).getGenericDeclaration()).equals(rawType)) {
                TypeVariable<?>[] typeParams = owner.getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParams[i].equals(resolvedType)) continue;
                    return parameterizedType.getActualTypeArguments()[i];
                }
            }
        } else {
            throw new UnsupportedOperationException("Todo " + type.getTypeName() + " " + type.getClass().getName());
        }
        return null;
    }

    public static Element resolveSignature(Elements elementUtils, Types typeUtils, TypeElement declaringElt, String signature) {
        Matcher signatureMatcher = SIGNATURE_PATTERN.matcher(signature);
        if (signatureMatcher.find()) {
            String memberName = signatureMatcher.group(1);
            String typeName = signature.substring(0, signatureMatcher.start());
            TypeElement typeElt = Helper.resolveTypeElement(elementUtils, declaringElt, typeName);
            if (typeElt != null) {
                Predicate<Element> memberMatcher;
                if (signatureMatcher.group(2) != null) {
                    String t = signatureMatcher.group(2).trim();
                    Predicate<ExecutableElement> parametersMatcher = t.length() == 0 ? exeElt -> exeElt.getParameters().isEmpty() : Helper.parametersMatcher(typeUtils, t.split("\\s*,\\s*"));
                    memberMatcher = elt -> Helper.matchesConstructor(elt, memberName, parametersMatcher) || Helper.matchesMethod(elt, memberName, parametersMatcher);
                } else {
                    memberMatcher = elt -> Helper.matchesConstructor(elt, memberName, exeElt -> true) || Helper.matchesMethod(elt, memberName, exeElt -> true) || Helper.matchesField(elt, memberName);
                }
                for (ElementKind kind : Arrays.asList(ElementKind.FIELD, ElementKind.CONSTRUCTOR, ElementKind.METHOD)) {
                    for (Element element : elementUtils.getAllMembers(typeElt)) {
                        if (element.getKind() != kind || !memberMatcher.test(element)) continue;
                        return element;
                    }
                }
            }
            return null;
        }
        return Helper.resolveTypeElement(elementUtils, declaringElt, signature);
    }

    private static TypeElement resolveTypeElement(Elements elementUtils, TypeElement declaringElt, String typeName) {
        TypeElement resolvedElt;
        if (typeName.isEmpty()) {
            resolvedElt = declaringElt;
        } else if (typeName.lastIndexOf(46) == -1) {
            resolvedElt = elementUtils.getTypeElement("java.lang." + typeName);
            if (resolvedElt == null) {
                String packageName = elementUtils.getPackageOf(declaringElt).getQualifiedName().toString();
                resolvedElt = elementUtils.getTypeElement(packageName + '.' + typeName);
            }
        } else {
            resolvedElt = elementUtils.getTypeElement(typeName);
        }
        return resolvedElt;
    }

    private static boolean matchesConstructor(Element elt, String memberName, Predicate<ExecutableElement> parametersMatcher) {
        if (elt.getKind() == ElementKind.CONSTRUCTOR) {
            ExecutableElement constructorElt = (ExecutableElement)elt;
            TypeElement typeElt = (TypeElement)constructorElt.getEnclosingElement();
            return typeElt.getSimpleName().toString().equals(memberName) && parametersMatcher.test(constructorElt);
        }
        return false;
    }

    private static boolean matchesMethod(Element elt, String memberName, Predicate<ExecutableElement> parametersMatcher) {
        if (elt.getKind() == ElementKind.METHOD) {
            ExecutableElement methodElt = (ExecutableElement)elt;
            return methodElt.getSimpleName().toString().equals(memberName) && parametersMatcher.test(methodElt);
        }
        return false;
    }

    private static boolean matchesField(Element elt, String memberName) {
        return elt.getKind() == ElementKind.FIELD && elt.getSimpleName().toString().equals(memberName);
    }

    private static Predicate<ExecutableElement> parametersMatcher(Types typeUtils, String[] parameterSignature) {
        return exeElt -> {
            if (exeElt.getParameters().size() == parameterSignature.length) {
                TypeMirror tm2 = exeElt.asType();
                ExecutableType tm3 = (ExecutableType)typeUtils.erasure(tm2);
                for (int j = 0; j < parameterSignature.length; ++j) {
                    String t1 = tm3.getParameterTypes().get(j).toString();
                    String t2 = parameterSignature[j];
                    if (t2.indexOf(46) == -1) {
                        t1 = t1.substring(t1.lastIndexOf(46) + 1);
                    }
                    if (t1.equals(t2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static TypeElement getElementTypeOf(Element elt) {
        ElementKind kind = elt.getKind();
        if (kind == ElementKind.CLASS || kind == ElementKind.INTERFACE || kind == ElementKind.ENUM) {
            return (TypeElement)elt;
        }
        Element enclosingElt = elt.getEnclosingElement();
        if (enclosingElt != null) {
            return Helper.getElementTypeOf(enclosingElt);
        }
        return null;
    }

    public static String normalizeWhitespaces(String s) {
        Matcher matcher = WHITESPACE_CLUSTER_PATTERN.matcher(s);
        return matcher.replaceAll(" ").trim();
    }

    public static Set<DeclaredType> resolveAncestorTypes(TypeElement typeElt, boolean withSuper, boolean withInterfaces) {
        LinkedHashSet<DeclaredType> ancestors = new LinkedHashSet<DeclaredType>();
        Helper.resolveAncestorTypes(typeElt, ancestors, withSuper, withInterfaces);
        return ancestors;
    }

    private static void resolveAncestorTypes(TypeElement typeElt, Set<DeclaredType> ancestors, boolean withSuper, boolean withInterfaces) {
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        if (withSuper && typeElt.getSuperclass() != null) {
            superTypes.add(typeElt.getSuperclass());
        }
        if (withInterfaces) {
            superTypes.addAll(typeElt.getInterfaces());
        }
        for (TypeMirror typeMirror : superTypes) {
            DeclaredType superDeclaredType;
            if (typeMirror.getKind() != TypeKind.DECLARED || ancestors.contains(superDeclaredType = (DeclaredType)typeMirror)) continue;
            ancestors.add(superDeclaredType);
            Helper.resolveAncestorTypes((TypeElement)superDeclaredType.asElement(), ancestors, withSuper, withInterfaces);
        }
    }

    static void checkUnderModule(Model model, String annotation) {
        if (model.getModule() == null) {
            throw new GenException(model.getElement(), "Declaration annotated with " + annotation + " must be under a package annotatedwith @ModuleGen. Check that the package '" + model.getFqn() + "' or a parent package contains a 'package-info.java' using the @ModuleGen annotation");
        }
    }

    static void ensureParentDir(File f) {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
    }

    static String toString(TypeMirror mirror) {
        StringBuilder buffer = new StringBuilder();
        Helper.toString(mirror, buffer);
        return buffer.toString();
    }

    static void toString(TypeMirror mirror, StringBuilder buffer) {
        switch (mirror.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)mirror;
                TypeElement elt = (TypeElement)dt.asElement();
                buffer.append(elt.getQualifiedName().toString());
                List<? extends TypeMirror> args = dt.getTypeArguments();
                if (args.size() <= 0) break;
                buffer.append("<");
                for (int i = 0; i < args.size(); ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    Helper.toString(args.get(i), buffer);
                }
                buffer.append(">");
                break;
            }
            case WILDCARD: {
                WildcardType wt = (WildcardType)mirror;
                buffer.append("?");
                if (wt.getSuperBound() != null) {
                    buffer.append(" super ");
                    Helper.toString(wt.getSuperBound(), buffer);
                    break;
                }
                if (wt.getExtendsBound() == null) break;
                buffer.append(" extends ");
                Helper.toString(wt.getExtendsBound(), buffer);
                break;
            }
            case TYPEVAR: {
                javax.lang.model.type.TypeVariable tv = (javax.lang.model.type.TypeVariable)mirror;
                TypeParameterElement elt = (TypeParameterElement)tv.asElement();
                buffer.append(elt.getSimpleName().toString());
                if (tv.getUpperBound() != null && !tv.getUpperBound().toString().equals("java.lang.Object")) {
                    buffer.append(" extends ");
                    Helper.toString(tv.getUpperBound(), buffer);
                    break;
                }
                if (tv.getLowerBound() == null || tv.getLowerBound().getKind() == TypeKind.NULL) break;
                buffer.append(" super ");
                Helper.toString(tv.getUpperBound(), buffer);
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case BOOLEAN: {
                PrimitiveType pm = (PrimitiveType)mirror;
                buffer.append(pm.getKind().name().toLowerCase());
                break;
            }
            case ARRAY: {
                ArrayType at = (ArrayType)mirror;
                Helper.toString(at.getComponentType(), buffer);
                buffer.append("[]");
                break;
            }
            default: {
                throw new UnsupportedOperationException("todo " + mirror + " " + (Object)((Object)mirror.getKind()));
            }
        }
    }

    public static Method getReflectMethod(ProcessingEnvironment env, ExecutableElement modelMethod) {
        ClassLoader loader = CodeGen.loaderMap.get(env);
        if (loader != null) {
            return Helper.getReflectMethod(loader, modelMethod);
        }
        return null;
    }

    public static Method getReflectMethod(ClassLoader loader, ExecutableElement modelMethod) {
        TypeElement typeElt = (TypeElement)modelMethod.getEnclosingElement();
        Method method = null;
        try {
            Class<?> clazz = loader.loadClass(typeElt.getQualifiedName().toString());
            StringBuilder sb = new StringBuilder(modelMethod.getSimpleName());
            sb.append("(");
            List<? extends VariableElement> params = modelMethod.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                VariableElement param = params.get(i);
                Helper.toString(param.asType(), sb);
            }
            sb.append(")");
            String s = sb.toString();
            for (Method m : clazz.getMethods()) {
                String sign = m.toGenericString();
                int pos = sign.indexOf(40);
                pos = sign.lastIndexOf(46, pos) + 1;
                sign = sign.substring(pos);
                if (!(sign = sign.replace(", ", ",")).equals(s)) continue;
                if (method != null) {
                    if (!method.getReturnType().isAssignableFrom(m.getReturnType())) continue;
                    method = m;
                    continue;
                }
                method = m;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return method;
    }

    public static boolean isDataObjectAnnotatedSerializable(Elements elementUtils, TypeElement dataObjectElt) {
        return elementUtils.getAllMembers(dataObjectElt).stream().flatMap(FILTER_METHOD).anyMatch(exeElt -> exeElt.getSimpleName().toString().equals("toJson") && exeElt.getReturnType().toString().equals("io.vertx.core.json.JsonObject"));
    }

    public static boolean isConcreteClass(TypeElement element) {
        return element.getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static boolean isAbstractClassOrInterface(TypeElement element) {
        return element.getKind().isInterface() || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static boolean isDataObjectAnnotatedDeserializable(Elements elementUtils, Types typeUtils, TypeElement dataObjectElt) {
        return Helper.isConcreteClass(dataObjectElt) && elementUtils.getAllMembers(dataObjectElt).stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).anyMatch(constructor -> constructor.getParameters().size() == 1 && constructor.getModifiers().contains((Object)Modifier.PUBLIC) && constructor.getParameters().get(0).asType().toString().equals("io.vertx.core.json.JsonObject"));
    }

    public static boolean isGenIgnore(Element elt) {
        return elt.getAnnotation(GenIgnore.class) != null;
    }
}

