/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.generators.mvel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.codegen.CodeGenProcessor;
import io.vertx.codegen.Generator;
import io.vertx.codegen.GeneratorLoader;
import io.vertx.codegen.generators.mvel.MvelCodeGenerator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

public class MvelCodeGeneratorLoader
implements GeneratorLoader {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Stream<Generator<?>> loadGenerators(ProcessingEnvironment processingEnv) {
        ArrayList<MvelCodeGenerator> generators = new ArrayList<MvelCodeGenerator>();
        Enumeration<Object> descriptors = Collections.emptyEnumeration();
        try {
            descriptors = CodeGenProcessor.class.getClassLoader().getResources("codegen.json");
        }
        catch (IOException ignore) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator descriptors");
        }
        HashSet<String> templates = new HashSet<String>();
        while (descriptors.hasMoreElements()) {
            URL descriptor = (URL)descriptors.nextElement();
            try {
                Scanner scanner = new Scanner(descriptor.openStream(), "UTF-8").useDelimiter("\\A");
                Throwable throwable = null;
                try {
                    String s = scanner.next();
                    ObjectNode obj = (ObjectNode)mapper.readTree(s);
                    String name = obj.get("name").asText();
                    ArrayNode generatorsCfg = (ArrayNode)obj.get("generators");
                    for (JsonNode generator : generatorsCfg) {
                        boolean incremental;
                        HashSet<String> kinds = new HashSet<String>();
                        if (generator.get("kind").isArray()) {
                            generator.get("kind").forEach(v -> kinds.add(v.asText()));
                        } else {
                            kinds.add(generator.get("kind").asText());
                        }
                        JsonNode templateFilenameNode = generator.get("templateFilename");
                        if (templateFilenameNode == null) {
                            templateFilenameNode = generator.get("templateFileName");
                        }
                        String templateFilename = templateFilenameNode.asText();
                        JsonNode filenameNode = generator.get("filename");
                        if (filenameNode == null) {
                            filenameNode = generator.get("fileName");
                        }
                        String filename = filenameNode.asText();
                        boolean bl = incremental = generator.has("incremental") && generator.get("incremental").asBoolean();
                        if (templates.contains(templateFilename)) continue;
                        templates.add(templateFilename);
                        MvelCodeGenerator gen = new MvelCodeGenerator();
                        gen.name = name;
                        gen.kinds = kinds;
                        gen.incremental = incremental;
                        gen.filename = filename;
                        gen.templateFilename = templateFilename;
                        generators.add(gen);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            catch (Exception e) {
                String msg = "Could not load code generator " + descriptor;
                CodeGenProcessor.log.log(Level.SEVERE, msg, e);
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        return generators.stream();
    }
}

