/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.Helper;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ArrayTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeUse;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeMirrorFactory {
    final Elements elementUtils;
    final Types typeUtils;

    public TypeMirrorFactory(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public TypeInfo create(TypeMirror type) {
        return this.create(null, type);
    }

    public TypeInfo create(TypeUse use, TypeMirror type) {
        switch (type.getKind()) {
            case VOID: {
                return VoidTypeInfo.INSTANCE;
            }
            case ERROR: 
            case DECLARED: {
                return this.create(use, (DeclaredType)type);
            }
            case DOUBLE: 
            case LONG: 
            case FLOAT: 
            case CHAR: 
            case BYTE: 
            case SHORT: 
            case BOOLEAN: 
            case INT: {
                if (use != null && use.isNullable()) {
                    throw new IllegalArgumentException("Primitive types cannot be annotated with @Nullable");
                }
                return PrimitiveTypeInfo.PRIMITIVES.get(type.getKind().name().toLowerCase());
            }
            case TYPEVAR: {
                return this.create(use, (TypeVariable)type);
            }
            case ARRAY: {
                return this.create(use, (ArrayType)type);
            }
        }
        throw new IllegalArgumentException("Illegal type " + type + " of kind " + (Object)((Object)type.getKind()));
    }

    public TypeInfo create(DeclaredType type) {
        return this.create(null, type);
    }

    public TypeInfo create(TypeUse use, DeclaredType type) {
        return this.create(use, type, true);
    }

    /*
     * WARNING - void declaration
     */
    public TypeInfo create(TypeUse use, DeclaredType type, boolean checkTypeArgs) {
        void var12_22;
        boolean proxyGen;
        boolean nullable = use != null && use.isNullable();
        TypeElement elt = (TypeElement)type.asElement();
        PackageElement pkgElt = this.elementUtils.getPackageOf(elt);
        ModuleInfo module = ModuleInfo.resolve(this.elementUtils, pkgElt);
        String fqcn = elt.getQualifiedName().toString();
        boolean bl = proxyGen = elt.getAnnotation(ProxyGen.class) != null;
        if (elt.getKind() == ElementKind.ENUM) {
            ArrayList<String> values = new ArrayList<String>();
            for (Element element : elt.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                values.add(element.getSimpleName().toString());
            }
            boolean gen = elt.getAnnotation(VertxGen.class) != null;
            return new EnumTypeInfo(fqcn, gen, values, module, nullable);
        }
        ClassKind kind = ClassKind.getKind(fqcn, elt.getAnnotation(DataObject.class) != null, elt.getAnnotation(VertxGen.class) != null);
        List<? extends TypeMirror> typeArgs = type.getTypeArguments();
        if (checkTypeArgs && typeArgs.size() > 0) {
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>(typeArgs.size());
            for (int i = 0; i < typeArgs.size(); ++i) {
                TypeUse argUse = use != null ? use.getArg(fqcn, i) : null;
                TypeInfo typeArgDesc = this.create(argUse, typeArgs.get(i));
                arrayList.add(typeArgDesc);
            }
            ClassTypeInfo raw2 = (ClassTypeInfo)this.create(null, (DeclaredType)type.asElement().asType(), false);
            return new ParameterizedTypeInfo(raw2, nullable, arrayList);
        }
        if (kind == ClassKind.BOXED_PRIMITIVE) {
            ClassTypeInfo classTypeInfo = ClassTypeInfo.PRIMITIVES.get(fqcn);
            if (nullable) {
                ClassTypeInfo classTypeInfo2 = new ClassTypeInfo(classTypeInfo.kind, classTypeInfo.name, classTypeInfo.module, true, classTypeInfo.params);
            }
        } else {
            List<TypeParamInfo.Class> typeParams = this.createTypeParams(type);
            if (kind == ClassKind.API) {
                VertxGen genAnn = elt.getAnnotation(VertxGen.class);
                TypeInfo[] args = (TypeInfo[])Stream.of("io.vertx.core.streams.ReadStream", "io.vertx.core.streams.WriteStream", "io.vertx.core.Handler").map(s -> {
                    TypeElement parameterizedElt = this.elementUtils.getTypeElement((CharSequence)s);
                    TypeMirror parameterizedType = parameterizedElt.asType();
                    TypeMirror rawType = this.typeUtils.erasure(parameterizedType);
                    if (this.typeUtils.isSubtype(type, rawType)) {
                        DeclaredType dt;
                        TypeElement a;
                        TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, type, parameterizedElt.getTypeParameters().get(0));
                        if (resolved.getKind() == TypeKind.DECLARED && (a = (TypeElement)(dt = (DeclaredType)resolved).asElement()).getQualifiedName().toString().equals("io.vertx.core.AsyncResult")) {
                            return null;
                        }
                        return this.create(resolved);
                    }
                    return null;
                }).toArray(TypeInfo[]::new);
                ApiTypeInfo apiTypeInfo = new ApiTypeInfo(fqcn, genAnn.concrete(), typeParams, args[0], args[1], args[2], module, nullable, proxyGen);
            } else if (kind == ClassKind.DATA_OBJECT) {
                boolean _abstract = elt.getModifiers().contains((Object)Modifier.ABSTRACT);
                DataObjectTypeInfo dataObjectTypeInfo = new DataObjectTypeInfo(kind, fqcn, module, _abstract, nullable, typeParams);
            } else {
                ClassTypeInfo classTypeInfo = new ClassTypeInfo(kind, fqcn, module, nullable, typeParams);
            }
        }
        return var12_22;
    }

    public TypeVariableInfo create(TypeUse use, TypeVariable type) {
        TypeParameterElement elt = (TypeParameterElement)type.asElement();
        TypeParamInfo param = TypeParamInfo.create(elt);
        return new TypeVariableInfo(param, use != null && use.isNullable(), elt.getSimpleName().toString());
    }

    public ArrayTypeInfo create(TypeUse use, ArrayType type) {
        TypeMirror componentType = type.getComponentType();
        return new ArrayTypeInfo(this.create(componentType), use != null && use.isNullable());
    }

    private List<TypeParamInfo.Class> createTypeParams(DeclaredType type) {
        ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
        TypeElement elt = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParamElts = elt.getTypeParameters();
        for (int index = 0; index < typeParamElts.size(); ++index) {
            TypeParameterElement typeParamElt = typeParamElts.get(index);
            typeParams.add(new TypeParamInfo.Class(elt.getQualifiedName().toString(), index, typeParamElt.getSimpleName().toString()));
        }
        return typeParams;
    }
}

