/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.Signature;
import io.vertx.codegen.TypeArgExpression;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MethodInfo
implements Comparable<MethodInfo> {
    final String name;
    final MethodKind kind;
    final TypeInfo returnType;
    final Text returnDescription;
    final boolean fluent;
    final boolean cacheReturn;
    final String comment;
    final Doc doc;
    final boolean staticMethod;
    final boolean defaultMethod;
    List<TypeParamInfo.Method> typeParams;
    LinkedHashSet<ClassTypeInfo> ownerTypes;
    List<ParamInfo> params;

    public MethodInfo(Set<ClassTypeInfo> ownerTypes, String name, MethodKind kind, TypeInfo returnType, Text returnDescription, boolean fluent, boolean cacheReturn, List<ParamInfo> params, String comment, Doc doc, boolean staticMethod, boolean defaultMethod, List<TypeParamInfo.Method> typeParams) {
        this.comment = comment;
        this.kind = kind;
        this.name = name;
        this.returnType = returnType;
        this.returnDescription = returnDescription;
        this.fluent = fluent;
        this.cacheReturn = cacheReturn;
        this.doc = doc;
        this.staticMethod = staticMethod;
        this.defaultMethod = defaultMethod;
        this.params = params;
        this.typeParams = typeParams;
        this.ownerTypes = new LinkedHashSet<ClassTypeInfo>(ownerTypes);
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.CAMEL.parse(this.name));
    }

    public MethodKind getKind() {
        return this.kind;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public ParamInfo resolveClassTypeParam(TypeVariableInfo typeVar) {
        TypeArgExpression res = this.resolveTypeArg(typeVar);
        if (res != null && res.isClassType()) {
            return res.getParam();
        }
        return null;
    }

    public TypeArgExpression resolveTypeArg(TypeVariableInfo typeVar) {
        for (TypeParamInfo.Method typeParam : this.typeParams) {
            if (!typeParam.getName().equals(typeVar.getName())) continue;
            for (ParamInfo param : this.params) {
                if (param.getType().getKind() == ClassKind.CLASS_TYPE && param.getType().isParameterized()) {
                    TypeVariableInfo ttt;
                    TypeInfo arg_ = ((ParameterizedTypeInfo)param.getType()).getArg(0);
                    if (!arg_.isVariable() || !(ttt = (TypeVariableInfo)arg_).getParam().equals(typeParam)) continue;
                    return new TypeArgExpression(0, ttt, param, 0);
                }
                if (param.getType().getKind() != ClassKind.API || !param.getType().isParameterized()) continue;
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)param.getType();
                int index = 0;
                for (TypeInfo i : type.getArgs()) {
                    TypeVariableInfo tt;
                    if (i instanceof TypeVariableInfo && (tt = (TypeVariableInfo)i).getParam().equals(typeParam)) {
                        return new TypeArgExpression(1, tt, param, index);
                    }
                    ++index;
                }
            }
            return null;
        }
        return null;
    }

    public Text getReturnDescription() {
        return this.returnDescription;
    }

    public Set<ClassTypeInfo> getOwnerTypes() {
        return this.ownerTypes;
    }

    public Signature getSignature() {
        return new Signature(this.name, new ArrayList<ParamInfo>(this.params));
    }

    public boolean isOwnedBy(ClassTypeInfo owner) {
        return this.ownerTypes.contains(owner) && this.ownerTypes.size() == 1;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public boolean isCacheReturn() {
        return this.cacheReturn;
    }

    public boolean isNullableReturn() {
        return this.returnType.isNullable();
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public ParamInfo getParam(int index) {
        return this.params.get(index);
    }

    public String getComment() {
        return this.comment;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public List<TypeParamInfo.Method> getTypeParams() {
        return this.typeParams;
    }

    public void mergeTypeParams(List<TypeParamInfo.Method> mergedTypeParams) throws IllegalArgumentException {
        int l = Math.min(this.typeParams.size(), mergedTypeParams.size());
        if (this.typeParams.subList(0, l).equals(mergedTypeParams.subList(0, l))) {
            if (mergedTypeParams.size() > this.typeParams.size()) {
                this.typeParams.addAll(mergedTypeParams.subList(this.typeParams.size(), mergedTypeParams.size()));
            }
        } else {
            throw new IllegalArgumentException("Merged type params " + mergedTypeParams + " don't match the existing ones " + this.typeParams);
        }
    }

    public void collectImports(Collection<ClassTypeInfo> imports) {
        this.params.stream().map(ParamInfo::getType).forEach(a -> a.collectImports(imports));
    }

    @Override
    public int compareTo(MethodInfo o) {
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        Iterator<ParamInfo> i1 = this.params.iterator();
        Iterator<ParamInfo> i2 = o.params.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            ParamInfo p1 = i1.next();
            ParamInfo p2 = i2.next();
            cmp = p1.getType().getRaw().getName().compareTo(p2.getType().getRaw().getName());
            if (cmp == 0) continue;
            return cmp;
        }
        if (i1.hasNext()) {
            if (!i2.hasNext()) {
                return 1;
            }
        } else if (!i2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeParams.size() > 0) {
            for (int i = 0; i < this.typeParams.size(); ++i) {
                sb.append(i > 0 ? ", " : "<");
                sb.append(this.typeParams.get(i).getName());
            }
            sb.append("> ");
        }
        sb.append(this.returnType.getName());
        sb.append(' ');
        sb.append(this.getSignature().toString());
        return sb.toString();
    }
}

