/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.type.TypeInfo;

public class PropertyInfo {
    final PropertyKind kind;
    final boolean declared;
    final String name;
    final Doc doc;
    final TypeInfo type;
    final String setterMethod;
    final String adderMethod;
    final String getterMethod;
    final boolean jsonifiable;

    public PropertyInfo(boolean declared, String name, Doc doc, TypeInfo type, String setterMethod, String adderMethod, String getterMethod, PropertyKind kind, boolean jsonifiable) {
        this.kind = kind;
        this.declared = declared;
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.adderMethod = adderMethod;
        this.setterMethod = setterMethod;
        this.getterMethod = getterMethod;
        this.jsonifiable = jsonifiable;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public String getGetterMethod() {
        return this.getterMethod;
    }

    public String getSetterMethod() {
        return this.setterMethod;
    }

    public String getAdderMethod() {
        return this.adderMethod;
    }

    public boolean isValue() {
        return this.kind == PropertyKind.VALUE;
    }

    public boolean isList() {
        return this.kind == PropertyKind.LIST;
    }

    public boolean isSet() {
        return this.kind == PropertyKind.SET;
    }

    public boolean isMap() {
        return this.kind == PropertyKind.MAP;
    }

    public boolean isSetter() {
        return this.setterMethod != null;
    }

    public boolean isAdder() {
        return this.adderMethod != null;
    }

    public boolean isJsonifiable() {
        return this.jsonifiable;
    }
}

