/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.overloadcheck.MethodOverloadChecker;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codegen.type.TypeUse;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ClassModel
implements Model {
    private static final Logger logger = Logger.getLogger(ClassModel.class.getName());
    public static final String VERTX_READ_STREAM = "io.vertx.core.streams.ReadStream";
    public static final String VERTX_WRITE_STREAM = "io.vertx.core.streams.WriteStream";
    public static final String VERTX_ASYNC_RESULT = "io.vertx.core.AsyncResult";
    public static final String VERTX_HANDLER = "io.vertx.core.Handler";
    public static final String JSON_OBJECT = "io.vertx.core.json.JsonObject";
    public static final String JSON_ARRAY = "io.vertx.core.json.JsonArray";
    public static final String VERTX = "io.vertx.core.Vertx";
    protected final MethodOverloadChecker methodOverloadChecker;
    protected final Messager messager;
    protected final TypeMirrorFactory typeFactory;
    protected final Doc.Factory docFactory;
    protected final Map<String, TypeElement> sources;
    protected final TypeElement modelElt;
    protected final Elements elementUtils;
    protected final Types typeUtils;
    protected boolean processed = false;
    protected LinkedHashMap<ExecutableElement, MethodInfo> methods = new LinkedHashMap();
    protected Set<ClassTypeInfo> collectedTypes = new HashSet<ClassTypeInfo>();
    protected Set<ClassTypeInfo> importedTypes = new HashSet<ClassTypeInfo>();
    protected Set<ApiTypeInfo> referencedTypes = new HashSet<ApiTypeInfo>();
    protected Set<ClassTypeInfo> referencedDataObjectTypes = new HashSet<ClassTypeInfo>();
    protected boolean concrete;
    protected ClassTypeInfo type;
    protected String ifaceSimpleName;
    protected String ifaceFQCN;
    protected String ifacePackageName;
    protected String ifaceComment;
    protected Doc doc;
    protected List<TypeInfo> superTypes = new ArrayList<TypeInfo>();
    protected TypeInfo concreteSuperType;
    protected List<TypeInfo> abstractSuperTypes = new ArrayList<TypeInfo>();
    protected TypeInfo handlerSuperType;
    protected Map<String, List<MethodInfo>> methodMap = new LinkedHashMap<String, List<MethodInfo>>();

    public ClassModel(MethodOverloadChecker methodOverloadChecker, Messager messager, Map<String, TypeElement> sources, Elements elementUtils, Types typeUtils, TypeElement modelElt) {
        this.methodOverloadChecker = methodOverloadChecker;
        this.typeFactory = new TypeMirrorFactory(elementUtils, typeUtils);
        this.docFactory = new Doc.Factory(messager, elementUtils, typeUtils, this.typeFactory, modelElt);
        this.messager = messager;
        this.sources = sources;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelElt = modelElt;
    }

    @Override
    public String getKind() {
        return "class";
    }

    @Override
    public String getFqn() {
        return this.type.getRaw().getName();
    }

    @Override
    public TypeElement getElement() {
        return this.modelElt;
    }

    public List<MethodInfo> getMethods() {
        return new ArrayList<MethodInfo>(this.methods.values());
    }

    public List<MethodInfo> getStaticMethods() {
        return this.methods.values().stream().filter(MethodInfo::isStaticMethod).collect(Collectors.toList());
    }

    public List<MethodInfo> getInstanceMethods() {
        return this.methods.values().stream().filter(m -> !m.isStaticMethod()).collect(Collectors.toList());
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<ClassTypeInfo> getImportedTypes() {
        return this.importedTypes;
    }

    public Set<ApiTypeInfo> getReferencedTypes() {
        return this.referencedTypes;
    }

    public Set<ClassTypeInfo> getReferencedDataObjectTypes() {
        return this.referencedDataObjectTypes;
    }

    public String getIfaceSimpleName() {
        return this.ifaceSimpleName;
    }

    public String getIfaceFQCN() {
        return this.ifaceFQCN;
    }

    public String getIfacePackageName() {
        return this.ifacePackageName;
    }

    public String getIfaceComment() {
        return this.ifaceComment;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public ClassTypeInfo getType() {
        return this.type;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    public List<TypeInfo> getSuperTypes() {
        return this.superTypes;
    }

    public TypeInfo getConcreteSuperType() {
        return this.concreteSuperType;
    }

    public List<TypeInfo> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public TypeInfo getHandlerSuperType() {
        return this.handlerSuperType;
    }

    public Map<String, List<MethodInfo>> getMethodMap() {
        return this.methodMap;
    }

    public List<TypeParamInfo.Class> getTypeParams() {
        return this.type.getRaw().getParams();
    }

    private void sortMethodMap(Map<String, List<MethodInfo>> map) {
        for (List<MethodInfo> list : map.values()) {
            list.sort((meth1, meth2) -> meth1.params.size() - meth2.params.size());
        }
    }

    protected void checkParamType(Element elem, TypeMirror type, TypeInfo typeInfo, int pos, int numParams) {
        if (this.isLegalNonCallbackParam(typeInfo)) {
            return;
        }
        if (this.isLegalHandlerType(typeInfo)) {
            return;
        }
        if (this.isLegalHandlerAsyncResultType(typeInfo)) {
            return;
        }
        if (this.isLegalFunctionType(typeInfo)) {
            return;
        }
        throw new GenException(elem, "type " + typeInfo + " is not legal for use for a parameter in code generation");
    }

    protected void checkReturnType(ExecutableElement elem, TypeInfo type, TypeMirror typeMirror) {
        if (type.getKind().basic || type instanceof VoidTypeInfo || type.getKind().json) {
            return;
        }
        if (this.isLegalEnum(type)) {
            return;
        }
        if (type.getKind() == ClassKind.THROWABLE) {
            return;
        }
        if (this.isLegalListSetMapReturn(type)) {
            return;
        }
        if (this.isVertxGenInterface(type)) {
            return;
        }
        if (this.isLegalDataObjectTypeReturn(type)) {
            return;
        }
        if (this.isVariableType(type)) {
            return;
        }
        if (this.isLegalHandlerType(type)) {
            return;
        }
        if (this.isLegalHandlerAsyncResultType(type)) {
            return;
        }
        throw new GenException(elem, "type " + type + " is not legal for use for a return type in code generation");
    }

    private boolean isLegalEnum(TypeInfo info) {
        return info.getKind() == ClassKind.ENUM;
    }

    private boolean isLegalNonCallbackParam(TypeInfo typeInfo) {
        if (typeInfo.getKind().basic || typeInfo.getKind().json || typeInfo.getKind() == ClassKind.OBJECT || typeInfo.getKind() == ClassKind.THROWABLE) {
            return true;
        }
        if (this.isLegalEnum(typeInfo)) {
            return true;
        }
        if (this.isLegalListSetMapParam(typeInfo)) {
            return true;
        }
        if (this.isVertxGenInterface(typeInfo)) {
            return true;
        }
        if (this.isLegalDataObjectTypeParam(typeInfo)) {
            return true;
        }
        return this.isVariableType(typeInfo);
    }

    private boolean isVariableType(TypeInfo type) {
        return type instanceof TypeVariableInfo;
    }

    private boolean isLegalDataObjectTypeParam(TypeInfo type) {
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            DataObjectTypeInfo classType = (DataObjectTypeInfo)type;
            return !classType.isAbstract();
        }
        return false;
    }

    protected boolean isLegalDataObjectTypeReturn(TypeInfo type) {
        TypeElement typeElt;
        if (type.getKind() == ClassKind.DATA_OBJECT && (typeElt = this.elementUtils.getTypeElement(type.getName())) != null) {
            Optional<ExecutableElement> opt = this.elementUtils.getAllMembers(typeElt).stream().flatMap(Helper.FILTER_METHOD).filter(m -> m.getSimpleName().toString().equals("toJson") && m.getParameters().isEmpty() && m.getReturnType().toString().equals(JSON_OBJECT)).findFirst();
            return opt.isPresent();
        }
        return false;
    }

    protected boolean isLegalListSetMapParam(TypeInfo type) {
        if (ClassModel.rawTypeIs(type, List.class, Set.class, Map.class)) {
            TypeInfo argument = ((ParameterizedTypeInfo)type).getArgs().get(0);
            if (type.getKind() != ClassKind.MAP) {
                if (argument.getKind().basic || argument.getKind().json || this.isVertxGenInterface(argument) || this.isLegalDataObjectTypeParam(argument) || argument.getKind() == ClassKind.ENUM) {
                    return true;
                }
            } else if (argument.getKind() == ClassKind.STRING) {
                argument = ((ParameterizedTypeInfo)type).getArgs().get(1);
                if (argument.getKind().basic || argument.getKind().json || this.isVertxGenInterface(argument)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isLegalListSetMapReturn(TypeInfo type) {
        if (ClassModel.rawTypeIs(type, List.class, Set.class, Map.class)) {
            List<TypeInfo> args = ((ParameterizedTypeInfo)type).getArgs();
            if (type.getKind() == ClassKind.MAP) {
                if (args.get(0).getKind() != ClassKind.STRING) {
                    return false;
                }
                TypeInfo valueType = args.get(1);
                if (valueType.getKind().basic || valueType.getKind().json) {
                    return true;
                }
            } else {
                TypeInfo valueType = args.get(0);
                if (valueType.getKind().basic || valueType.getKind().json || valueType.getKind() == ClassKind.ENUM || this.isVertxGenInterface(valueType) || this.isLegalDataObjectTypeReturn(valueType)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isVertxGenInterface(TypeInfo type) {
        if (type.getKind() == ClassKind.API) {
            if (type instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterized = (ParameterizedTypeInfo)type;
                for (TypeInfo param : parameterized.getArgs()) {
                    if (!(param instanceof TypeVariableInfo) && param.getKind() != ClassKind.VOID) {
                        return false;
                    }
                    if (!param.isNullable()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isLegalFunctionType(TypeInfo typeInfo) {
        TypeInfo paramType;
        if (typeInfo.getErased().getKind() == ClassKind.FUNCTION && (this.isLegalCallbackValueType(paramType = ((ParameterizedTypeInfo)typeInfo).getArgs().get(0)) || paramType.getKind() == ClassKind.THROWABLE)) {
            TypeInfo returnType = ((ParameterizedTypeInfo)typeInfo).getArgs().get(1);
            return this.isLegalNonCallbackParam(returnType);
        }
        return false;
    }

    private boolean isLegalHandlerType(TypeInfo type) {
        TypeInfo eventType;
        return type.getErased().getKind() == ClassKind.HANDLER && (this.isLegalCallbackValueType(eventType = ((ParameterizedTypeInfo)type).getArgs().get(0)) || eventType.getKind() == ClassKind.THROWABLE);
    }

    private boolean isLegalHandlerAsyncResultType(TypeInfo type) {
        TypeInfo resultType;
        TypeInfo eventType;
        return type.getErased().getKind() == ClassKind.HANDLER && (eventType = ((ParameterizedTypeInfo)type).getArgs().get(0)).getErased().getKind() == ClassKind.ASYNC_RESULT && !eventType.isNullable() && this.isLegalCallbackValueType(resultType = ((ParameterizedTypeInfo)eventType).getArgs().get(0));
    }

    private boolean isLegalCallbackValueType(TypeInfo type) {
        if (type.getKind() == ClassKind.VOID && type.isNullable()) {
            return false;
        }
        return type.getKind().json || type.getKind().basic || this.isVertxGenInterface(type) || this.isLegalListSetMapReturn(type) || type.getKind() == ClassKind.ENUM || type.getKind() == ClassKind.VOID || this.isVariableType(type) || type.getKind() == ClassKind.OBJECT || this.isLegalDataObjectTypeReturn(type);
    }

    private void determineApiTypes() {
        this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(ClassTypeInfo.class)).filter(t -> !t.getPackageName().equals(this.ifaceFQCN)).forEach(this.importedTypes::add);
        this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(ApiTypeInfo.class)).filter(t -> !t.equals(this.type.getRaw())).forEach(this.referencedTypes::add);
        this.collectedTypes.stream().map(ClassTypeInfo::getRaw).flatMap(Helper.instanceOf(ClassTypeInfo.class)).filter(t -> t.getKind() == ClassKind.DATA_OBJECT).forEach(this.referencedDataObjectTypes::add);
    }

    boolean process() {
        if (!this.processed) {
            this.traverseElem(this.modelElt);
            this.determineApiTypes();
            this.processed = true;
            return true;
        }
        return false;
    }

    private void traverseElem(Element elem) {
        switch (elem.getKind()) {
            case ENUM: 
            case CLASS: {
                throw new GenException(elem, "@VertxGen can only be used with interfaces or enums in " + elem.asType().toString());
            }
            case INTERFACE: {
                if (this.ifaceFQCN != null) {
                    throw new GenException(elem, "Can only have one interface per file");
                }
                this.type = this.typeFactory.create(elem.asType()).getRaw();
                Helper.checkUnderModule(this, "@VertxGen");
                this.ifaceFQCN = elem.asType().toString();
                this.ifaceSimpleName = elem.getSimpleName().toString();
                this.ifacePackageName = this.elementUtils.getPackageOf(elem).getQualifiedName().toString();
                this.ifaceComment = this.elementUtils.getDocComment(elem);
                this.doc = this.docFactory.createDoc(elem);
                this.concrete = elem.getAnnotation(VertxGen.class) == null || elem.getAnnotation(VertxGen.class).concrete();
                DeclaredType tm = (DeclaredType)elem.asType();
                List<? extends TypeMirror> list = tm.getTypeArguments();
                for (TypeMirror typeMirror : list) {
                    TypeVariable typeVariable = (TypeVariable)typeMirror;
                    if (this.isObjectBound(typeVariable.getUpperBound())) continue;
                    throw new GenException(elem, "Type variable bounds not supported " + typeVariable.getUpperBound());
                }
                List<? extends TypeMirror> st = this.typeUtils.directSupertypes(tm);
                for (TypeMirror typeMirror : st) {
                    TypeInfo superTypeInfo;
                    if (typeMirror.toString().equals(Object.class.getName())) continue;
                    try {
                        superTypeInfo = this.typeFactory.create(typeMirror);
                    }
                    catch (IllegalArgumentException e) {
                        throw new GenException(elem, e.getMessage());
                    }
                    switch (superTypeInfo.getKind()) {
                        case API: {
                            try {
                                ApiTypeInfo superType = (ApiTypeInfo)this.typeFactory.create(typeMirror).getRaw();
                                if (superType.isConcrete()) {
                                    if (this.concrete) {
                                        if (this.concreteSuperType != null) {
                                            throw new GenException(elem, "A concrete interface cannot extend more than one concrete interfaces");
                                        }
                                    } else {
                                        throw new GenException(elem, "A abstract interface cannot extend a concrete interface");
                                    }
                                    this.concreteSuperType = superTypeInfo;
                                } else {
                                    this.abstractSuperTypes.add(superTypeInfo);
                                }
                                this.superTypes.add(superTypeInfo);
                                break;
                            }
                            catch (Exception e) {
                                throw new GenException(elem, e.getMessage());
                            }
                        }
                        case HANDLER: {
                            this.handlerSuperType = superTypeInfo;
                        }
                    }
                    superTypeInfo.collectImports(this.collectedTypes);
                }
                break;
            }
        }
        for (Element element : elem.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD) continue;
            this.traverseElem(element);
        }
        if (elem.getKind() == ElementKind.INTERFACE) {
            boolean bl;
            TypeMirror objectType = this.elementUtils.getTypeElement("java.lang.Object").asType();
            this.elementUtils.getAllMembers((TypeElement)elem).stream().filter(elt -> !this.typeUtils.isSameType(elt.getEnclosingElement().asType(), objectType)).flatMap(Helper.FILTER_METHOD).forEach(this::addMethod);
            boolean bl2 = bl = this.methods.values().stream().filter(m -> !m.isDefaultMethod()).count() == 0L;
            if (bl && this.superTypes.isEmpty()) {
                throw new GenException(elem, "Interface " + this.ifaceFQCN + " does not contain any methods for generation");
            }
            this.sortMethodMap(this.methodMap);
            for (List<MethodInfo> list : this.methodMap.values()) {
                try {
                    this.methodOverloadChecker.checkAmbiguous(list);
                }
                catch (RuntimeException runtimeException) {
                    throw new GenException(elem, runtimeException.getMessage());
                }
                MethodInfo methodInfo = list.get(0);
                for (MethodInfo method : list) {
                    if (method.staticMethod == methodInfo.staticMethod) continue;
                    throw new GenException(elem, "Overloaded method " + method.getName() + " cannot be both static and instance");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMethod(ExecutableElement modelMethod) {
        ApiTypeInfo apiTypeInfo;
        TypeInfo lastParamType;
        TypeInfo returnType;
        boolean isFluent;
        void var12_15;
        ArrayList<Method> reflectMethods;
        boolean isIgnore;
        boolean bl = isIgnore = modelMethod.getAnnotation(GenIgnore.class) != null;
        if (isIgnore) {
            return;
        }
        Set<Modifier> mods = modelMethod.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            return;
        }
        TypeElement declaringElt = (TypeElement)modelMethod.getEnclosingElement();
        TypeInfo declaringType = this.typeFactory.create(declaringElt.asType());
        if (!declaringElt.equals(this.modelElt) && declaringType.getKind() != ClassKind.API && declaringType.getKind() != ClassKind.HANDLER) {
            return;
        }
        ClassTypeInfo type = this.typeFactory.create(declaringElt.asType()).getRaw();
        boolean isDefault = mods.contains((Object)Modifier.DEFAULT);
        boolean isStatic = mods.contains((Object)Modifier.STATIC);
        if (isStatic && !this.concrete) {
            throw new GenException(modelMethod, "Abstract interface cannot declare static methods");
        }
        boolean isCacheReturn = modelMethod.getAnnotation(CacheReturn.class) != null;
        ArrayList<TypeParamInfo.Method> typeParams = new ArrayList<TypeParamInfo.Method>();
        for (TypeParameterElement typeParameterElement : modelMethod.getTypeParameters()) {
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (this.isObjectBound(typeMirror)) continue;
                throw new GenException(modelMethod, "Type parameter bound not supported " + typeMirror);
            }
            typeParams.add((TypeParamInfo.Method)TypeParamInfo.create(typeParameterElement));
        }
        Method reflectMethod = Helper.getReflectMethod(modelMethod);
        if (reflectMethod != null) {
            reflectMethods = new ArrayList<Method>();
            reflectMethods.add(reflectMethod);
            Object var12_13 = null;
        } else {
            reflectMethods = null;
            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
            arrayList.add(modelMethod);
        }
        HashSet<ClassTypeInfo> hashSet = new HashSet<ClassTypeInfo>();
        hashSet.add(type);
        ArrayList<DeclaredType> ancestors = new ArrayList<DeclaredType>(Helper.resolveAncestorTypes(this.modelElt, true, true));
        Collections.sort(ancestors, (o1, o2) -> {
            if (this.typeUtils.isSubtype((TypeMirror)o1, (TypeMirror)o2)) {
                return -1;
            }
            if (this.typeUtils.isSubtype((TypeMirror)o2, (TypeMirror)o1)) {
                return 1;
            }
            return ((TypeElement)o1.asElement()).getQualifiedName().toString().compareTo(((TypeElement)o2.asElement()).getQualifiedName().toString());
        });
        for (DeclaredType ancestorType : ancestors) {
            TypeElement ancestorElt = (TypeElement)ancestorType.asElement();
            if (ancestorElt.getAnnotation(VertxGen.class) == null) continue;
            this.elementUtils.getAllMembers(ancestorElt).stream().flatMap(Helper.FILTER_METHOD).filter(meth -> this.elementUtils.overrides(modelMethod, (ExecutableElement)meth, this.modelElt)).forEach(arg_0 -> this.lambda$addMethod$10(reflectMethods, (List)var12_15, hashSet, ancestorElt, arg_0));
        }
        HashMap<String, String> paramDescs = new HashMap<String, String>();
        String comment = this.elementUtils.getDocComment(modelMethod);
        Doc doc = this.docFactory.createDoc(modelMethod);
        Text returnDesc = null;
        if (doc != null) {
            doc.getBlockTags().stream().filter(tag -> tag.getName().equals("param")).map(Tag.Param::new).forEach(tag -> paramDescs.put(tag.getParamName(), tag.getParamDescription()));
            Optional<Tag> returnTag = doc.getBlockTags().stream().filter(tag -> tag.getName().equals("return")).findFirst();
            if (returnTag.isPresent()) {
                returnDesc = new Text(Helper.normalizeWhitespaces(returnTag.get().getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
            }
        }
        List<ParamInfo> mParams = this.getParams(reflectMethods, (List<ExecutableElement>)var12_15, modelMethod, paramDescs);
        AnnotationMirror fluentAnnotation = Helper.resolveMethodAnnotation(Fluent.class, this.elementUtils, this.typeUtils, declaringElt, modelMethod);
        boolean bl2 = isFluent = fluentAnnotation != null;
        if (isFluent) {
            isFluent = true;
            if (!this.typeUtils.isSameType(declaringElt.asType(), this.modelElt.asType())) {
                String msg = "Interface " + this.modelElt + " does not redeclare the @Fluent return type  of method " + modelMethod + " declared by " + declaringElt;
                this.messager.printMessage(Diagnostic.Kind.WARNING, msg, this.modelElt, fluentAnnotation);
                logger.warning(msg);
            } else {
                TypeMirror fluentType = modelMethod.getReturnType();
                if (!this.typeUtils.isAssignable(fluentType, this.modelElt.asType())) {
                    throw new GenException(modelMethod, "Methods marked with @Fluent must have a return type that extends the type");
                }
            }
        }
        TypeUse returnTypeUse = reflectMethods != null ? TypeUse.createTypeUse((AnnotatedType[])reflectMethods.stream().map(Method::getAnnotatedReturnType).toArray(AnnotatedType[]::new)) : TypeUse.createTypeUse((TypeMirror[])var12_15.stream().map(ExecutableElement::getReturnType).toArray(TypeMirror[]::new));
        ExecutableType methodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.modelElt.asType(), modelMethod);
        try {
            returnType = this.typeFactory.create(returnTypeUse, methodType.getReturnType());
        }
        catch (Exception e) {
            GenException genEx = new GenException(modelMethod, e.getMessage());
            genEx.initCause(e);
            throw genEx;
        }
        returnType.collectImports(this.collectedTypes);
        if (isCacheReturn && returnType instanceof VoidTypeInfo) {
            throw new GenException(modelMethod, "void method can't be marked with @CacheReturn");
        }
        String methodName = modelMethod.getSimpleName().toString();
        if (!isFluent) {
            this.checkReturnType(modelMethod, returnType, methodType.getReturnType());
        } else if (returnType.isNullable()) {
            throw new GenException(modelMethod, "Fluent return type cannot be nullable");
        }
        MethodKind kind = MethodKind.OTHER;
        int lastParamIndex = mParams.size() - 1;
        if (lastParamIndex >= 0 && (returnType instanceof VoidTypeInfo || isFluent) && (lastParamType = mParams.get((int)lastParamIndex).type).getKind() == ClassKind.HANDLER) {
            TypeInfo typeArg = ((ParameterizedTypeInfo)lastParamType).getArgs().get(0);
            kind = typeArg.getKind() == ClassKind.ASYNC_RESULT ? MethodKind.FUTURE : MethodKind.HANDLER;
        }
        MethodInfo methodInfo = this.createMethodInfo(hashSet, methodName, comment, doc, kind, returnType, returnDesc, isFluent, isCacheReturn, mParams, modelMethod, isStatic, isDefault, typeParams, declaringElt);
        this.checkMethod(methodInfo);
        for (Map.Entry entry : this.methods.entrySet()) {
            ExecutableType t2;
            ExecutableType t1;
            if (!((MethodInfo)entry.getValue()).getName().equals(modelMethod.getSimpleName().toString()) || !this.typeUtils.isSubsignature(t1 = (ExecutableType)((ExecutableElement)entry.getKey()).asType(), t2 = (ExecutableType)modelMethod.asType()) || !this.typeUtils.isSubsignature(t2, t1)) continue;
            ((MethodInfo)entry.getValue()).ownerTypes.addAll(methodInfo.ownerTypes);
            return;
        }
        List<MethodInfo> methodsByName = this.methodMap.get(methodInfo.getName());
        if (methodsByName == null) {
            methodsByName = new ArrayList<MethodInfo>();
            this.methodMap.put(methodInfo.getName(), methodsByName);
        }
        methodsByName.add(methodInfo);
        methodInfo.collectImports(this.collectedTypes);
        if (!declaringElt.equals(this.modelElt) && declaringType.getKind() == ClassKind.API && (apiTypeInfo = (ApiTypeInfo)declaringType.getRaw()).isConcrete() && this.typeUtils.isSameType(methodType, modelMethod.asType())) {
            return;
        }
        this.methods.put(modelMethod, methodInfo);
    }

    protected MethodInfo createMethodInfo(Set<ClassTypeInfo> ownerTypes, String methodName, String comment, Doc doc, MethodKind kind, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt) {
        return new MethodInfo(ownerTypes, methodName, kind, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams);
    }

    protected void checkMethod(MethodInfo methodInfo) {
        List<MethodInfo> methodsByName = this.methodMap.get(methodInfo.getName());
        if (methodsByName != null) {
            for (MethodInfo meth : methodsByName) {
                if (meth.returnType.equals(methodInfo.returnType)) continue;
                throw new GenException(this.modelElt, "Overloaded method " + methodInfo.name + " must have the same return type " + meth.returnType + " != " + methodInfo.returnType);
            }
        }
    }

    private boolean isObjectBound(TypeMirror bound) {
        return bound.getKind() == TypeKind.DECLARED && bound.toString().equals(Object.class.getName());
    }

    private List<ParamInfo> getParams(List<Method> reflectMethods, List<ExecutableElement> modelMethods, ExecutableElement methodElt, Map<String, String> descs) {
        ExecutableType methodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.modelElt.asType(), methodElt);
        List<? extends VariableElement> params = methodElt.getParameters();
        ArrayList<ParamInfo> mParams = new ArrayList<ParamInfo>();
        for (int i = 0; i < params.size(); ++i) {
            TypeInfo typeInfo;
            VariableElement param = params.get(i);
            TypeMirror type = methodType.getParameterTypes().get(i);
            int index = i;
            TypeUse typeUse = reflectMethods != null ? TypeUse.createTypeUse((AnnotatedType[])reflectMethods.stream().map(m -> m.getAnnotatedParameterTypes()[index]).toArray(AnnotatedType[]::new)) : TypeUse.createTypeUse((TypeMirror[])modelMethods.stream().map(m -> m.getParameters().get(index).asType()).toArray(TypeMirror[]::new));
            try {
                typeInfo = this.typeFactory.create(typeUse, type);
            }
            catch (Exception e) {
                throw new GenException(param, e.getMessage());
            }
            this.checkParamType(methodElt, type, typeInfo, i, params.size());
            String name = param.getSimpleName().toString();
            String desc = descs.get(name);
            Text text = desc != null ? new Text(desc).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt)) : null;
            ParamInfo mParam = new ParamInfo(i, name, text, typeInfo);
            mParams.add(mParam);
        }
        return mParams;
    }

    @Override
    public Map<String, Object> getVars() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("importedTypes", this.getImportedTypes());
        vars.put("concrete", this.isConcrete());
        vars.put("type", this.getType());
        vars.put("ifacePackageName", this.getIfacePackageName());
        vars.put("ifaceSimpleName", this.getIfaceSimpleName());
        vars.put("ifaceFQCN", this.getIfaceFQCN());
        vars.put("ifaceComment", this.getIfaceComment());
        vars.put("doc", this.doc);
        vars.put("helper", new Helper());
        vars.put("methods", this.getMethods());
        vars.put("referencedTypes", this.getReferencedTypes());
        vars.put("superTypes", this.getSuperTypes());
        vars.put("concreteSuperType", this.getConcreteSuperType());
        vars.put("abstractSuperTypes", this.getAbstractSuperTypes());
        vars.put("handlerSuperType", this.getHandlerSuperType());
        vars.put("methodsByName", this.getMethodMap());
        vars.put("referencedDataObjectTypes", this.getReferencedDataObjectTypes());
        vars.put("typeParams", this.getTypeParams());
        vars.put("instanceMethods", this.getInstanceMethods());
        vars.put("staticMethods", this.getStaticMethods());
        return vars;
    }

    private static boolean rawTypeIs(TypeInfo type, Class<?> ... classes) {
        if (type instanceof ParameterizedTypeInfo) {
            String rawClassName = type.getRaw().getName();
            for (Class<?> c : classes) {
                if (!rawClassName.equals(c.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

