/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.Helper;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.Variance;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.streams.ReadStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class TypeInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo create(Type type) {
        if (type == java.lang.Void.TYPE) {
            return Void.INSTANCE;
        }
        if (type instanceof java.lang.Class) {
            String fqcn = type.getTypeName();
            java.lang.Class classType = (java.lang.Class)type;
            if (classType.isPrimitive()) {
                return (TypeInfo)Primitive.PRIMITIVES.get(classType.getName());
            }
            Package pkg = classType.getPackage();
            ModuleInfo module = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classType.getClassLoader());
            try {
                while (pkg != null) {
                    ModuleGen annotation = pkg.getAnnotation(ModuleGen.class);
                    if (annotation != null) {
                        module = new ModuleInfo(pkg.getName(), annotation.name(), annotation.groupPackage());
                        break;
                    }
                    int pos = pkg.getName().lastIndexOf(46);
                    if (pos == -1) {
                        break;
                    }
                    pkg = Package.getPackage(pkg.getName().substring(0, pos));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (classType.isEnum()) {
                return new Class.Enum(fqcn, classType.getDeclaredAnnotation(VertxGen.class) != null, Stream.of(classType.getEnumConstants()).map(Object::toString).collect(Collectors.toList()), module, false);
            }
            ClassKind kind = Helper.getKind(classType::getAnnotation, fqcn);
            ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
            int index = 0;
            for (TypeVariable var : classType.getTypeParameters()) {
                typeParams.add(new TypeParamInfo.Class(classType.getName(), index++, var.getName(), Collections.emptySet()));
            }
            if (kind == ClassKind.API) {
                TypeVariable classTypeVariable = ReadStream.class.getTypeParameters()[0];
                Type readStreamArg = Helper.resolveTypeParameter(type, classTypeVariable);
                return new Class.Api(fqcn, true, typeParams, readStreamArg != null ? TypeInfo.create(readStreamArg) : null, null, null, module, false);
            }
            return new Class(kind, fqcn, module, false, typeParams);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            List<TypeInfo> args = Arrays.asList(parameterizedType.getActualTypeArguments()).stream().map(TypeInfo::create).collect(Collectors.toList());
            Type raw = parameterizedType.getRawType();
            return new Parameterized((Class)TypeInfo.create(raw), args);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            TypeParamInfo param = TypeParamInfo.create(typeVar);
            return new Variable(param, ((TypeVariable)type).getName());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void collectImports(Collection<Class> imports) {
    }

    public TypeInfo getErased() {
        return this;
    }

    public Class getRaw() {
        return null;
    }

    public ClassKind getKind() {
        return ClassKind.OTHER;
    }

    public String getName() {
        return this.format(true);
    }

    public String translateName(String lang) {
        return this.getName();
    }

    public String getSimpleName() {
        return this.format(false);
    }

    public String toString() {
        return this.getName();
    }

    abstract String format(boolean var1);

    public static class Void
    extends TypeInfo {
        public static TypeInfo INSTANCE = new Void(){};

        private Void() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Void;
        }

        @Override
        public String format(boolean qualified) {
            return "void";
        }
    }

    public static class Class
    extends TypeInfo {
        private static final HashMap<String, Class> PRIMITIVES;
        final ClassKind kind;
        final String name;
        final String simpleName;
        final String packageName;
        final ModuleInfo module;
        final boolean proxyGen;
        final List<TypeParamInfo.Class> params;

        public Class(ClassKind kind, String name, ModuleInfo module, boolean proxyGen, List<TypeParamInfo.Class> params) {
            this.kind = kind;
            this.name = name;
            this.simpleName = Helper.getSimpleName(name);
            this.packageName = Helper.getPackageName(name);
            this.module = module;
            this.proxyGen = proxyGen;
            this.params = params;
        }

        public List<TypeParamInfo.Class> getParams() {
            return this.params;
        }

        public String getModuleName() {
            return this.module != null ? this.module.getName() : null;
        }

        public ModuleInfo getModule() {
            return this.module;
        }

        @Override
        public ClassKind getKind() {
            return this.kind;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getSimpleName(Case _case) {
            return _case.format(Case.CAMEL.parse(this.simpleName));
        }

        public boolean isProxyGen() {
            return this.proxyGen;
        }

        @Override
        public Class getRaw() {
            return this;
        }

        @Override
        public void collectImports(Collection<Class> imports) {
            imports.add(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Class) {
                return this.name.equals(((Class)obj).name);
            }
            return false;
        }

        @Override
        public String format(boolean qualified) {
            return qualified ? this.name : this.simpleName;
        }

        public String translatePackageName(String id) {
            return this.module == null ? this.packageName : this.module.translateQualifiedName(this.packageName, id);
        }

        @Override
        public String translateName(String lang) {
            return this.module == null ? this.name : this.module.translateQualifiedName(this.name, lang);
        }

        static {
            java.lang.Class[] boxes;
            PRIMITIVES = new HashMap();
            for (java.lang.Class boxe : boxes = new java.lang.Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class}) {
                String name = boxe.getName();
                PRIMITIVES.put(name, new Class(ClassKind.BOXED_PRIMITIVE, name, null, false, Collections.emptyList()));
            }
        }

        public static class Api
        extends Class {
            final boolean concrete;
            final TypeInfo readStreamArg;
            final TypeInfo writeStreamArg;
            final TypeInfo handlerArg;

            public Api(String fqcn, boolean concrete, List<TypeParamInfo.Class> params, TypeInfo readStreamArg, TypeInfo writeStreamArg, TypeInfo handlerArg, ModuleInfo module, boolean proxyGen) {
                super(ClassKind.API, fqcn, module, proxyGen, params);
                this.concrete = concrete;
                this.readStreamArg = readStreamArg;
                this.writeStreamArg = writeStreamArg;
                this.handlerArg = handlerArg;
            }

            public boolean isConcrete() {
                return this.concrete;
            }

            public boolean isAbstract() {
                return !this.concrete;
            }

            public TypeInfo getReadStreamArg() {
                return this.readStreamArg;
            }

            public boolean isReadStream() {
                return this.readStreamArg != null;
            }

            public TypeInfo getWriteStreamArg() {
                return this.writeStreamArg;
            }

            public boolean isWriteStream() {
                return this.writeStreamArg != null;
            }

            public TypeInfo getHandlerArg() {
                return this.handlerArg;
            }

            public boolean isHandler() {
                return this.handlerArg != null;
            }
        }

        public static class Enum
        extends Class {
            final List<String> values;
            final boolean gen;

            public Enum(String fqcn, boolean gen, List<String> values, ModuleInfo module, boolean proxyGen) {
                super(ClassKind.ENUM, fqcn, module, proxyGen, Collections.emptyList());
                this.gen = gen;
                this.values = values;
            }

            public boolean isGen() {
                return this.gen;
            }

            public List<String> getValues() {
                return this.values;
            }
        }
    }

    public static class Parameterized
    extends TypeInfo {
        final Class raw;
        final List<TypeInfo> args;

        public Parameterized(Class raw, List<TypeInfo> args) {
            this.raw = raw;
            this.args = args;
        }

        @Override
        public TypeInfo getErased() {
            return new Parameterized(this.raw, this.args.stream().map(TypeInfo::getErased).collect(Collectors.toList()));
        }

        @Override
        public Class getRaw() {
            return this.raw;
        }

        public List<TypeInfo> getArgs() {
            return this.args;
        }

        public TypeInfo getArg(int index) {
            return this.args.get(index);
        }

        @Override
        public ClassKind getKind() {
            return this.raw.getKind();
        }

        @Override
        public void collectImports(Collection<Class> imports) {
            this.raw.collectImports(imports);
            this.args.stream().forEach(a -> a.collectImports(imports));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Parameterized) {
                Parameterized that = (Parameterized)obj;
                return this.raw.equals(that.raw) && this.args.equals(that.args);
            }
            return false;
        }

        @Override
        public String format(boolean qualified) {
            StringBuilder buf = new StringBuilder(this.raw.format(qualified)).append('<');
            for (int i = 0; i < this.args.size(); ++i) {
                TypeInfo typeArgument = this.args.get(i);
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(typeArgument.format(qualified));
            }
            buf.append('>');
            return buf.toString();
        }

        @Override
        public String translateName(String lang) {
            StringBuilder buf = new StringBuilder(this.raw.translateName(lang)).append('<');
            for (int i = 0; i < this.args.size(); ++i) {
                TypeInfo typeArgument = this.args.get(i);
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(typeArgument.translateName(lang));
            }
            buf.append('>');
            return buf.toString();
        }
    }

    public static class Variable
    extends TypeInfo {
        final String name;
        final TypeParamInfo param;

        public Variable(TypeParamInfo param, String name) {
            this.param = param;
            this.name = name;
        }

        public TypeParamInfo getParam() {
            return this.param;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Variable) {
                Variable that = (Variable)obj;
                return this.param.equals(that.param);
            }
            return false;
        }

        @Override
        public TypeInfo getErased() {
            return new Class(ClassKind.OBJECT, Object.class.getName(), null, false, Collections.emptyList());
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public String format(boolean qualified) {
            return this.name;
        }

        @Override
        public ClassKind getKind() {
            return ClassKind.OBJECT;
        }
    }

    public static class Primitive
    extends TypeInfo {
        private static final HashMap<String, Primitive> PRIMITIVES = new HashMap();
        final String name;
        final String boxedName;

        private Primitive(String name, String boxedName) {
            this.name = name;
            this.boxedName = boxedName;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Primitive) {
                return this.name.equals(((Primitive)obj).name);
            }
            return false;
        }

        public Class getBoxed() {
            return (Class)Class.PRIMITIVES.get(this.boxedName);
        }

        @Override
        public ClassKind getKind() {
            return ClassKind.PRIMITIVE;
        }

        @Override
        public String format(boolean qualified) {
            return this.name;
        }

        static {
            java.lang.Class[] primitives = new java.lang.Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE};
            java.lang.Class[] boxes = new java.lang.Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class};
            for (int i = 0; i < primitives.length; ++i) {
                java.lang.Class primitive = primitives[i];
                String name = primitive.getName();
                PRIMITIVES.put(name, new Primitive(primitive.getName(), boxes[i].getName()));
            }
        }
    }

    public static class Factory {
        final Elements elementUtils;
        final Types typeUtils;

        public Factory(Elements elementUtils, Types typeUtils) {
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
        }

        public TypeInfo create(TypeMirror type) {
            switch (type.getKind()) {
                case VOID: {
                    return Void.INSTANCE;
                }
                case ERROR: 
                case DECLARED: {
                    return this.create((DeclaredType)type);
                }
                case DOUBLE: 
                case LONG: 
                case FLOAT: 
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case BOOLEAN: 
                case INT: {
                    return (TypeInfo)Primitive.PRIMITIVES.get(type.toString());
                }
                case TYPEVAR: {
                    return this.create((javax.lang.model.type.TypeVariable)type);
                }
            }
            throw new IllegalArgumentException("Illegal type " + type + " of kind " + (Object)((Object)type.getKind()));
        }

        public TypeInfo create(DeclaredType type) {
            Class raw;
            boolean proxyGen;
            Element elt = type.asElement();
            PackageElement pkgElt = this.elementUtils.getPackageOf(elt);
            ModuleInfo module = ModuleInfo.resolve(this.elementUtils, pkgElt);
            String fqcn = this.typeUtils.erasure(type).toString();
            boolean bl = proxyGen = elt.getAnnotation(ProxyGen.class) != null;
            if (elt.getKind() == ElementKind.ENUM) {
                ArrayList<String> values = new ArrayList<String>();
                for (Element element : elt.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    values.add(element.getSimpleName().toString());
                }
                boolean gen = elt.getAnnotation(VertxGen.class) != null;
                return new Class.Enum(fqcn, gen, values, module, proxyGen);
            }
            ClassKind kind = Helper.getKind(annotationType -> elt.getAnnotation(annotationType), fqcn);
            if (kind == ClassKind.BOXED_PRIMITIVE) {
                raw = (Class)Class.PRIMITIVES.get(fqcn);
            } else {
                List<TypeParamInfo.Class> list = this.createTypeParams(type);
                if (kind == ClassKind.API) {
                    VertxGen genAnn = elt.getAnnotation(VertxGen.class);
                    TypeInfo[] args = (TypeInfo[])Stream.of("io.vertx.core.streams.ReadStream", "io.vertx.core.streams.WriteStream", "io.vertx.core.Handler").map(s -> {
                        TypeElement parameterizedElt = this.elementUtils.getTypeElement((CharSequence)s);
                        TypeMirror parameterizedType = parameterizedElt.asType();
                        TypeMirror rawType = this.typeUtils.erasure(parameterizedType);
                        if (this.typeUtils.isSubtype(type, rawType)) {
                            TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, type, parameterizedElt.getTypeParameters().get(0));
                            return this.create(resolved);
                        }
                        return null;
                    }).toArray(TypeInfo[]::new);
                    raw = new Class.Api(fqcn, genAnn.concrete(), list, args[0], args[1], args[2], module, proxyGen);
                } else {
                    raw = new Class(kind, fqcn, module, proxyGen, list);
                }
            }
            List<? extends TypeMirror> list = type.getTypeArguments();
            if (list.size() > 0) {
                ArrayList<TypeInfo> typeArguments = new ArrayList<TypeInfo>(list.size());
                for (TypeMirror typeMirror : list) {
                    TypeInfo typeArgDesc = this.create(typeMirror);
                    typeArguments.add(typeArgDesc);
                }
                return new Parameterized(raw, typeArguments);
            }
            return raw;
        }

        public Variable create(javax.lang.model.type.TypeVariable type) {
            TypeParameterElement elt = (TypeParameterElement)type.asElement();
            TypeParamInfo param = TypeParamInfo.create(elt);
            return new Variable(param, type.toString());
        }

        private List<TypeParamInfo.Class> createTypeParams(DeclaredType type) {
            ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
            TypeElement elt = (TypeElement)type.asElement();
            List<? extends TypeParameterElement> typeParamElts = elt.getTypeParameters();
            for (int index = 0; index < typeParamElts.size(); ++index) {
                TypeParameterElement typeParamElt = typeParamElts.get(index);
                EnumSet<Variance> siteVariance = EnumSet.noneOf(Variance.class);
                for (Variance variance : Variance.values()) {
                    if (!Helper.resolveSiteVariance(typeParamElt, variance)) continue;
                    siteVariance.add(variance);
                }
                typeParams.add(new TypeParamInfo.Class(elt.getQualifiedName().toString(), index, typeParamElt.getSimpleName().toString(), siteVariance));
            }
            return typeParams;
        }
    }
}

