/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.ClassKind;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.ProxyMethodInfo;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.ProxyClose;
import io.vertx.codegen.annotations.ProxyIgnore;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.overloadcheck.MethodOverloadChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProxyModel
extends ClassModel {
    public ProxyModel(MethodOverloadChecker methodOverloadChecker, Messager messager, Map<String, TypeElement> sources, Elements elementUtils, Types typeUtils, TypeElement modelElt) {
        super(methodOverloadChecker, messager, sources, elementUtils, typeUtils, modelElt);
    }

    @Override
    public String getKind() {
        return "proxy";
    }

    @Override
    protected void checkParamType(Element elem, TypeMirror type, TypeInfo typeInfo, int pos, int numParams) {
        if (typeInfo.getKind().basic || typeInfo.getKind().json) {
            return;
        }
        if (typeInfo.getKind() == ClassKind.ENUM) {
            return;
        }
        if (this.isLegalListSetMapParam(typeInfo)) {
            return;
        }
        if (typeInfo.getKind() == ClassKind.DATA_OBJECT && type instanceof DeclaredType) {
            List list = ((DeclaredType)type).asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().size() == 0 && e.getSimpleName().toString().equals("toJson")).map(e -> this.typeFactory.create(e.getReturnType())).filter(ti -> ti.getKind() == ClassKind.JSON_OBJECT).collect(Collectors.toList());
            if (list.size() == 1) {
                return;
            }
            throw new GenException(elem, "type " + typeInfo + " does not have a valid 'public JsonObject toJson()' method.");
        }
        if (this.isLegalHandlerAsyncResultType(typeInfo)) {
            if (pos != numParams - 1) {
                throw new GenException(elem, "Handler<AsyncResult<T>> must be the last parameter if present in a proxied method");
            }
            return;
        }
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        throw new GenException(elem, "type " + typeInfo + " is not legal for use for a parameter in proxy");
    }

    @Override
    protected void checkReturnType(ExecutableElement elem, TypeInfo type, TypeMirror typeMirror) {
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        if (type instanceof TypeInfo.Void) {
            return;
        }
        throw new GenException(elem, "Proxy methods must have void or Fluent returns");
    }

    @Override
    protected void checkMethod(MethodInfo methodInfo) {
        List methodsByName = (List)this.methodMap.get(methodInfo.getName());
        if (methodsByName != null) {
            throw new GenException(this.modelElt, "Overloaded methods are not allowed in ProxyGen interfaces " + methodInfo.name);
        }
    }

    @Override
    protected MethodInfo createMethodInfo(Set<TypeInfo.Class> ownerTypes, String methodName, String comment, Doc doc, MethodKind kind, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt) {
        boolean isProxyClose;
        AnnotationMirror proxyIgnoreAnnotation = Helper.resolveMethodAnnotation(ProxyIgnore.class, this.elementUtils, this.typeUtils, declaringElt, methodElt);
        boolean isProxyIgnore = proxyIgnoreAnnotation != null;
        AnnotationMirror proxyCloseAnnotation = Helper.resolveMethodAnnotation(ProxyClose.class, this.elementUtils, this.typeUtils, declaringElt, methodElt);
        boolean bl = isProxyClose = proxyCloseAnnotation != null;
        if (isProxyClose && mParams.size() > 0) {
            if (mParams.size() > 1) {
                throw new GenException(this.modelElt, "@ProxyClose methods can't have more than one parameter");
            }
            if (kind != MethodKind.FUTURE) {
                throw new GenException(this.modelElt, "@ProxyClose parameter must be Handler<AsyncResult<Void>>");
            }
            TypeInfo type = mParams.get(0).getType();
            TypeInfo arg = ((TypeInfo.Parameterized)((TypeInfo.Parameterized)type).getArgs().get(0)).getArgs().get(0);
            if (arg.getKind() != ClassKind.VOID) {
                throw new GenException(this.modelElt, "@ProxyClose parameter must be Handler<AsyncResult<Void>> instead of " + type);
            }
        }
        return new ProxyMethodInfo(ownerTypes, methodName, kind, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams, isProxyIgnore, isProxyClose);
    }

    private boolean isLegalHandlerAsyncResultType(TypeInfo type) {
        TypeInfo eventType;
        if (type.getErased().getKind() == ClassKind.HANDLER && (eventType = ((TypeInfo.Parameterized)type).getArgs().get(0)).getErased().getKind() == ClassKind.ASYNC_RESULT) {
            TypeInfo resultType = ((TypeInfo.Parameterized)eventType).getArgs().get(0);
            if (resultType.getKind().json || resultType.getKind().basic || this.isLegalListSetMapResult(resultType) || resultType.getKind() == ClassKind.VOID || resultType.getKind() == ClassKind.ENUM || resultType.getKind() == ClassKind.DATA_OBJECT) {
                return true;
            }
            if (resultType.getKind() == ClassKind.API) {
                TypeInfo.Class cla = (TypeInfo.Class)resultType;
                if (cla.proxyGen) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isLegalListSetMapResult(TypeInfo type) {
        if (type instanceof TypeInfo.Parameterized && (type.getKind() == ClassKind.LIST || type.getKind() == ClassKind.SET)) {
            TypeInfo elementType = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (elementType.getKind().basic || elementType.getKind().json || elementType.getKind() == ClassKind.DATA_OBJECT) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isLegalListSetMapParam(TypeInfo type) {
        TypeInfo.Class raw = type.getRaw();
        if (raw.getName().equals(List.class.getName()) || raw.getName().equals(Set.class.getName())) {
            TypeInfo argument = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (argument.getKind().basic || argument.getKind().json || argument.getKind() == ClassKind.DATA_OBJECT) {
                return true;
            }
        } else if (raw.getName().equals(Map.class.getName())) {
            TypeInfo argument0 = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (!argument0.getName().equals(String.class.getName())) {
                return false;
            }
            TypeInfo argument1 = ((TypeInfo.Parameterized)type).getArgs().get(1);
            if (argument1.getKind().basic || argument1.getKind().json) {
                return true;
            }
        }
        return false;
    }
}

