/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.doc.Doc;

public class PropertyInfo {
    final PropertyKind kind;
    final boolean declared;
    final String name;
    final Doc doc;
    final TypeInfo type;
    final String writerMethod;
    final String readerMethod;
    final boolean jsonifiable;

    public PropertyInfo(boolean declared, String name, Doc doc, TypeInfo type, String writerMethod, String readerMethod, PropertyKind kind, boolean jsonifiable) {
        this.kind = kind;
        this.declared = declared;
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.writerMethod = writerMethod;
        this.readerMethod = readerMethod;
        this.jsonifiable = jsonifiable;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public String getReaderMethod() {
        return this.readerMethod;
    }

    public String getWriterMethod() {
        return this.writerMethod;
    }

    public boolean isValue() {
        return this.kind == PropertyKind.VALUE;
    }

    public boolean isArray() {
        return this.kind == PropertyKind.LIST || this.kind == PropertyKind.LIST_ADD;
    }

    public boolean isMap() {
        return this.kind == PropertyKind.MAP;
    }

    public boolean isAdder() {
        return this.kind == PropertyKind.LIST_ADD;
    }

    public boolean isJsonifiable() {
        return this.jsonifiable;
    }
}

