/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.Signature;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MethodInfo
implements Comparable<MethodInfo> {
    final String name;
    final MethodKind kind;
    final TypeInfo returnType;
    final Text returnDescription;
    final boolean fluent;
    final boolean cacheReturn;
    final String comment;
    final Doc doc;
    final boolean staticMethod;
    List<TypeParamInfo.Method> typeParams;
    LinkedHashSet<TypeInfo.Class> ownerTypes;
    List<ParamInfo> params;

    public MethodInfo(Set<TypeInfo.Class> ownerTypes, String name, MethodKind kind, TypeInfo returnType, Text returnDescription, boolean fluent, boolean cacheReturn, List<ParamInfo> params, String comment, Doc doc, boolean staticMethod, List<TypeParamInfo.Method> typeParams) {
        this.comment = comment;
        this.kind = kind;
        this.name = name;
        this.returnType = returnType;
        this.returnDescription = returnDescription;
        this.fluent = fluent;
        this.cacheReturn = cacheReturn;
        this.doc = doc;
        this.staticMethod = staticMethod;
        this.params = params;
        this.typeParams = typeParams;
        this.ownerTypes = new LinkedHashSet<TypeInfo.Class>(ownerTypes);
    }

    public String getPropertyName() {
        if (this.kind == MethodKind.GETTER) {
            if (this.name.startsWith("is")) {
                return Helper.normalizePropertyName(this.name.substring(2));
            }
            return Helper.normalizePropertyName(this.name.substring(3));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.CAMEL.parse(this.name));
    }

    public MethodKind getKind() {
        return this.kind;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public Text getReturnDescription() {
        return this.returnDescription;
    }

    public Set<TypeInfo.Class> getOwnerTypes() {
        return this.ownerTypes;
    }

    public Signature getSignature() {
        return new Signature(this.name, new ArrayList<ParamInfo>(this.params));
    }

    public boolean isOwnedBy(TypeInfo.Class owner) {
        return this.ownerTypes.contains(owner) && this.ownerTypes.size() == 1;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public boolean isCacheReturn() {
        return this.cacheReturn;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public String getComment() {
        return this.comment;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public List<TypeParamInfo.Method> getTypeParams() {
        return this.typeParams;
    }

    public void mergeTypeParams(List<TypeParamInfo.Method> mergedTypeParams) throws IllegalArgumentException {
        int l = Math.min(this.typeParams.size(), mergedTypeParams.size());
        if (this.typeParams.subList(0, l).equals(mergedTypeParams.subList(0, l))) {
            if (mergedTypeParams.size() > this.typeParams.size()) {
                this.typeParams.addAll(mergedTypeParams.subList(this.typeParams.size(), mergedTypeParams.size()));
            }
        } else {
            throw new IllegalArgumentException("Merged type params " + mergedTypeParams + " don't match the existing ones " + this.typeParams);
        }
    }

    public void collectImports(Collection<TypeInfo.Class> imports) {
        this.params.stream().map(ParamInfo::getType).forEach(a -> a.collectImports(imports));
    }

    @Override
    public int compareTo(MethodInfo o) {
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        Iterator<ParamInfo> i1 = this.params.iterator();
        Iterator<ParamInfo> i2 = o.params.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            ParamInfo p1 = i1.next();
            ParamInfo p2 = i2.next();
            cmp = p1.getType().getRaw().getName().compareTo(p2.getType().getRaw().getName());
            if (cmp == 0) continue;
            return cmp;
        }
        if (i1.hasNext()) {
            if (!i2.hasNext()) {
                return 1;
            }
        } else if (!i2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.typeParams.size() > 0) {
            for (i = 0; i < this.typeParams.size(); ++i) {
                sb.append(i > 0 ? ", " : "<");
                sb.append(this.typeParams.get(i));
            }
            sb.append("> ");
        }
        sb.append(this.returnType.getName());
        sb.append(' ');
        sb.append(this.name);
        sb.append('(');
        if (this.params.size() > 0) {
            for (i = 0; i < this.params.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.params.get(i).getType().getName()).append(" ").append(this.params.get((int)i).type.getName());
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

