/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.codegen.CodeGen;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.Template;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.mvel2.MVEL;

@SupportedAnnotationTypes(value={"io.vertx.codegen.annotations.VertxGen", "io.vertx.codegen.annotations.ProxyGen", "io.vertx.codegen.annotations.DataObject", "io.vertx.codegen.annotations.GenModule"})
@SupportedOptions(value={"outputDirectory", "codeGenerators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodeGenProcessor
extends AbstractProcessor {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(CodeGenProcessor.class.getName());
    private File outputDirectory;
    private Map<String, List<CodeGenerator>> codeGenerators;

    private Collection<CodeGenerator> getCodeGenerators() {
        if (this.codeGenerators == null) {
            String codeGeneratorsOption;
            LinkedHashMap<String, List<CodeGenerator>> codeGenerators = new LinkedHashMap<String, List<CodeGenerator>>();
            Enumeration<Object> descriptors = Collections.emptyEnumeration();
            try {
                descriptors = CodeGenProcessor.class.getClassLoader().getResources("codegen.json");
            }
            catch (IOException ignore) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator descriptors");
            }
            while (descriptors.hasMoreElements()) {
                URL descriptor = (URL)descriptors.nextElement();
                try {
                    Scanner scanner = new Scanner(descriptor.openStream(), "UTF-8").useDelimiter("\\A");
                    Throwable throwable = null;
                    try {
                        String s = scanner.next();
                        ObjectNode obj = (ObjectNode)mapper.readTree(s);
                        String name = obj.get("name").asText();
                        ArrayNode generatorsCfg = (ArrayNode)obj.get("generators");
                        for (JsonNode generator : generatorsCfg) {
                            String kind = generator.get("kind").asText();
                            String templateFileName = generator.get("templateFileName").asText();
                            String fileName = generator.get("fileName").asText();
                            Serializable fileNameExpression = MVEL.compileExpression((String)fileName);
                            Template compiledTemplate = new Template(templateFileName);
                            compiledTemplate.setOptions(this.processingEnv.getOptions());
                            List generators = codeGenerators.computeIfAbsent(name, abc -> new ArrayList());
                            generators.add(new CodeGenerator(kind, fileNameExpression, compiledTemplate));
                        }
                        log.info("Loaded " + name + " code generator");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                catch (Exception e) {
                    String msg = "Could not load code generator " + descriptor;
                    log.log(Level.SEVERE, msg, e);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                }
            }
            String outputDirectoryOption = this.processingEnv.getOptions().get("outputDirectory");
            if (outputDirectoryOption != null) {
                this.outputDirectory = new File(outputDirectoryOption);
                if (!this.outputDirectory.exists()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " does not exist");
                }
                if (!this.outputDirectory.isDirectory()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " is not a directory");
                }
            }
            if ((codeGeneratorsOption = this.processingEnv.getOptions().get("codeGenerators")) != null) {
                Set wanted = Stream.of(codeGeneratorsOption.split(",")).map(String::trim).collect(Collectors.toSet());
                if (codeGenerators.keySet().containsAll(wanted)) {
                    codeGenerators.keySet().retainAll(wanted);
                } else {
                    codeGenerators.clear();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Code generators " + wanted.removeAll(codeGenerators.keySet()) + " not found");
                }
            }
            this.codeGenerators = codeGenerators;
        }
        ArrayList<CodeGenerator> ret = new ArrayList<CodeGenerator>();
        this.codeGenerators.values().stream().forEach(ret::addAll);
        return ret;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<CodeGenerator> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv, roundEnv);
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        if (this.outputDirectory != null) {
                            HashMap<String, Object> vars = new HashMap<String, Object>();
                            vars.put("helper", new Helper());
                            vars.put("options", this.processingEnv.getOptions());
                            vars.put("fileSeparator", File.separator);
                            vars.put("fqn", model.getFqn());
                            vars.putAll(model.getVars());
                            for (CodeGenerator codeGenerator : codeGenerators) {
                                Object target;
                                String relativeName;
                                if (!codeGenerator.kind.equals(model.getKind()) || (relativeName = (String)MVEL.executeExpression((Object)codeGenerator.filenameExpr, vars)) == null) continue;
                                if (relativeName.endsWith(".java")) {
                                    target = this.processingEnv.getFiler().createSourceFile(relativeName.substring(0, relativeName.length() - ".java".length()), new Element[0]);
                                    String output = codeGenerator.transformTemplate.render(model);
                                    try (Writer writer = target.openWriter();){
                                        writer.append(output);
                                    }
                                } else {
                                    target = new File(this.outputDirectory, relativeName);
                                    codeGenerator.transformTemplate.apply(model, (File)target);
                                }
                                log.info("Generated model " + model.getFqn() + ": " + relativeName);
                            }
                        } else {
                            log.info("Validated model " + model.getFqn());
                        }
                    }
                    catch (GenException e) {
                        String msg = "Could not generate model for " + e.element + ": " + e.msg;
                        log.log(Level.SEVERE, msg, e);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
                    }
                    catch (Exception e) {
                        String msg = "Could not generate element for " + entry.getKey() + ": " + e.getMessage();
                        log.log(Level.SEVERE, msg, e);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, (Element)entry.getKey());
                    }
                });
            }
        }
        return true;
    }

    static class CodeGenerator {
        final String kind;
        final Serializable filenameExpr;
        final Template transformTemplate;

        CodeGenerator(String kind, Serializable filenameExpr, Template transformTemplate) {
            this.kind = kind;
            this.filenameExpr = filenameExpr;
            this.transformTemplate = transformTemplate;
        }
    }
}

