/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.sqlclient.impl.SqlUserUtilImpl;
import io.vertx.sqlclient.SqlClient;

@VertxGen
public interface SqlUserUtil {
    public static SqlUserUtil create(SqlClient client) {
        return new SqlUserUtilImpl(client);
    }

    public static SqlUserUtil create(SqlClient client, String insertUserSQL, String insertUserRoleSQL, String insertRolePermissionSQL) {
        return new SqlUserUtilImpl(client, insertUserSQL, insertUserRoleSQL, insertRolePermissionSQL);
    }

    @Fluent
    default public SqlUserUtil createUser(String username, String password, Handler<AsyncResult<Void>> resultHandler) {
        this.createUser(username, password).onComplete(resultHandler);
        return this;
    }

    public Future<Void> createUser(String var1, String var2);

    @Fluent
    default public SqlUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<Void>> resultHandler) {
        this.createHashedUser(username, hash).onComplete(resultHandler);
        return this;
    }

    public Future<Void> createHashedUser(String var1, String var2);

    @Fluent
    default public SqlUserUtil createUserRole(String username, String role, Handler<AsyncResult<Void>> resultHandler) {
        this.createUserRole(username, role).onComplete(resultHandler);
        return this;
    }

    public Future<Void> createUserRole(String var1, String var2);

    @Fluent
    default public SqlUserUtil createRolePermission(String role, String permission, Handler<AsyncResult<Void>> resultHandler) {
        this.createRolePermission(role, permission).onComplete(resultHandler);
        return this;
    }

    public Future<Void> createRolePermission(String var1, String var2);
}

