/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.sqlclient.SqlAuthorization;
import io.vertx.ext.auth.sqlclient.SqlAuthorizationOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SqlAuthorizationImpl
implements SqlAuthorization {
    private final SqlAuthorizationOptions options;
    private final SqlClient client;

    public SqlAuthorizationImpl(SqlClient client, SqlAuthorizationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
    }

    public String getId() {
        return "sql-client";
    }

    private void getRoles(String username, Handler<AsyncResult<Set<Authorization>>> resultHandler) {
        if (this.options.getRolesQuery() != null) {
            this.client.preparedQuery(this.options.getRolesQuery()).execute(Tuple.of((Object)username), preparedQuery -> {
                if (preparedQuery.succeeded()) {
                    RowSet rows = (RowSet)preparedQuery.result();
                    HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
                    for (Row row : rows) {
                        String role = row.getString(0);
                        authorizations.add(RoleBasedAuthorization.create((String)role));
                    }
                    resultHandler.handle((Object)Future.succeededFuture(authorizations));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)preparedQuery.cause()));
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture(Collections.emptySet()));
        }
    }

    private void getPermissions(String username, Handler<AsyncResult<Set<Authorization>>> resultHandler) {
        if (this.options.getPermissionsQuery() != null) {
            this.client.preparedQuery(this.options.getPermissionsQuery()).execute(Tuple.of((Object)username), preparedQuery -> {
                if (preparedQuery.succeeded()) {
                    RowSet rows = (RowSet)preparedQuery.result();
                    HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
                    for (Row row : rows) {
                        String permission = row.getString(0);
                        authorizations.add(PermissionBasedAuthorization.create((String)permission));
                    }
                    resultHandler.handle((Object)Future.succeededFuture(authorizations));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)preparedQuery.cause()));
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture(Collections.emptySet()));
        }
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> resultHandler) {
        String username = user.principal().getString("username");
        if (username != null) {
            this.getRoles(username, (Handler<AsyncResult<Set<Authorization>>>)((Handler)roleResponse -> {
                if (roleResponse.succeeded()) {
                    HashSet authorizations = new HashSet((Collection)roleResponse.result());
                    this.getPermissions(username, (Handler<AsyncResult<Set<Authorization>>>)((Handler)permissionResponse -> {
                        if (permissionResponse.succeeded()) {
                            authorizations.addAll((Collection)permissionResponse.result());
                            user.authorizations().add(this.getId(), authorizations);
                            resultHandler.handle((Object)Future.succeededFuture());
                        } else {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)permissionResponse.cause()));
                        }
                    }));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)roleResponse.cause()));
                }
            }));
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"Couldn't get the username from the principal"));
        }
    }
}

