/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.Codec;
import java.util.Locale;

@DataObject
public class OtpKey {
    private String key;
    private String algorithm;

    public OtpKey() {
    }

    public OtpKey(OtpKey other) {
        this.key = other.key;
        this.algorithm = other.algorithm;
    }

    public OtpKey(JsonObject json) {
        this.setKey(json.getString("key"));
        this.setAlgorithm(json.getString("algorithm"));
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getKeyBytes() {
        return Codec.base32Decode((String)this.key);
    }

    public OtpKey setKey(String key) {
        this.key = key;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public OtpKey setAlgorithm(String algorithm) {
        algorithm = algorithm == null ? "SHA1" : algorithm.toUpperCase(Locale.US);
        switch (algorithm) {
            case "SHA1": 
            case "SHA256": 
            case "SHA512": {
                this.algorithm = algorithm;
                return this;
            }
        }
        throw new IllegalArgumentException("Invalid algorithm, must be SHA{1,256,512}");
    }

    public JsonObject toJson() {
        return new JsonObject().put("key", (Object)this.getKey()).put("algorithm", (Object)this.getAlgorithm());
    }

    public String toString() {
        return this.toJson().encode();
    }
}

