/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpCredentials;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.hotp.HotpAuth;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.auth.otp.impl.org.openauthentication.otp.OneTimePasswordAlgorithm;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.function.Function;

public class HotpAuthImpl
implements HotpAuth {
    private final HotpAuthOptions hotpAuthOptions;
    private Function<String, Future<Authenticator>> fetcher;
    private Function<Authenticator, Future<Void>> updater;

    public HotpAuthImpl(HotpAuthOptions hotpAuthOptions) {
        if (hotpAuthOptions == null) {
            throw new IllegalArgumentException("hotpAuthOptions cannot null");
        }
        this.hotpAuthOptions = hotpAuthOptions;
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(new OtpCredentials(credentials), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            OtpCredentials authInfo = (OtpCredentials)credentials;
            authInfo.checkValid(this.hotpAuthOptions);
            this.fetcher.apply(authInfo.getIdentifier()).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(authenticator -> {
                if (authenticator == null) {
                    resultHandler.handle((Object)Future.failedFuture((String)"user is not found"));
                } else {
                    String oneTimePassword;
                    int n;
                    long counter = authenticator.getCounter();
                    String key = authenticator.getKey();
                    String algorithm = authenticator.getAlgorithm();
                    OtpKey otpKey = new OtpKey().setKey(key).setAlgorithm(algorithm);
                    ++counter;
                    Integer authAttempts = authenticator.getAuthAttempts();
                    if (authAttempts != null) {
                        authAttempts = authAttempts + 1;
                        n = authAttempts;
                    } else {
                        n = 1;
                    }
                    authAttempts = n;
                    authenticator.setAuthAttempts(authAttempts);
                    try {
                        oneTimePassword = OneTimePasswordAlgorithm.generateOTP(otpKey.getKeyBytes(), counter, this.hotpAuthOptions.getPasswordLength(), false, -1);
                    }
                    catch (GeneralSecurityException e) {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                    if (oneTimePassword.equals(authInfo.getCode())) {
                        authenticator.setCounter(counter);
                        this.updater.apply((Authenticator)authenticator).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(v -> resultHandler.handle((Object)Future.succeededFuture((Object)this.createUser((Authenticator)authenticator))));
                        return;
                    }
                    if (this.hotpAuthOptions.isUsingAttemptsLimit() && authAttempts >= this.hotpAuthOptions.getAuthAttemptsLimit()) {
                        this.updater.apply((Authenticator)authenticator).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(v -> resultHandler.handle((Object)Future.failedFuture((String)"invalid code")));
                        return;
                    }
                    if (this.hotpAuthOptions.isUsingResynchronization()) {
                        for (int i = 0; i < this.hotpAuthOptions.getLookAheadWindow(); ++i) {
                            ++counter;
                            try {
                                oneTimePassword = OneTimePasswordAlgorithm.generateOTP(otpKey.getKeyBytes(), counter, this.hotpAuthOptions.getPasswordLength(), false, -1);
                            }
                            catch (GeneralSecurityException e) {
                                resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                                return;
                            }
                            if (!MessageDigest.isEqual(oneTimePassword.getBytes(StandardCharsets.UTF_8), authInfo.getCode().getBytes(StandardCharsets.UTF_8))) continue;
                            authenticator.setCounter(counter);
                            this.updater.apply((Authenticator)authenticator).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(v -> resultHandler.handle((Object)Future.succeededFuture((Object)this.createUser((Authenticator)authenticator))));
                            return;
                        }
                    }
                    resultHandler.handle((Object)Future.failedFuture((String)"invalid code"));
                }
            });
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public HotpAuth authenticatorFetcher(Function<String, Future<Authenticator>> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public HotpAuth authenticatorUpdater(Function<Authenticator, Future<Void>> updater) {
        this.updater = updater;
        return this;
    }

    @Override
    public Future<Authenticator> createAuthenticator(String id, OtpKey otpKey) {
        Authenticator authenticator = new Authenticator(true).setIdentifier(id).setKey(otpKey.getKey()).setAlgorithm(otpKey.getAlgorithm()).setCounter(this.hotpAuthOptions.getCounter());
        return this.updater.apply(authenticator).map((Object)authenticator);
    }

    @Override
    public String generateUri(OtpKey otpKey, String issuer, String user, String label) {
        try {
            if (label == null) {
                if (issuer == null) {
                    throw new IllegalArgumentException("label and issuer cannot all be null");
                }
                label = user == null ? URLEncoder.encode(issuer, "UTF8") : URLEncoder.encode(issuer, "UTF8") + ":" + URLEncoder.encode(user, "UTF8");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("secret=").append(otpKey.getKey());
            if (issuer != null) {
                sb.append("&issuer=").append(URLEncoder.encode(issuer, "UTF8"));
            }
            if (otpKey.getAlgorithm() != null && !otpKey.getAlgorithm().equals("SHA1")) {
                sb.append("&algorithm=").append(otpKey.getAlgorithm());
            }
            if (this.hotpAuthOptions.getPasswordLength() != 6) {
                sb.append("&digits=").append(this.hotpAuthOptions.getPasswordLength());
            }
            sb.append("&counter=").append(this.hotpAuthOptions.getCounter());
            return String.format("otpauth://hotp/%s?%s", label, sb);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private User createUser(Authenticator authenticator) {
        return User.create((JsonObject)new JsonObject().put("otp", (Object)"hotp").put("counter", (Object)authenticator.getCounter()).put("auth_attempts", (Object)authenticator.getAuthAttempts()));
    }
}

