/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.impl.org.openauthentication.otp;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OneTimePasswordAlgorithm {
    private static final int[] doubleDigits = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    private OneTimePasswordAlgorithm() {
    }

    public static int calcChecksum(long num, int digits) {
        boolean doubleDigit = true;
        int total = 0;
        while (0 < digits--) {
            int digit = (int)(num % 10L);
            num /= 10L;
            if (doubleDigit) {
                digit = doubleDigits[digit];
            }
            total += digit;
            doubleDigit = !doubleDigit;
        }
        int result = total % 10;
        if (result > 0) {
            result = 10 - result;
        }
        return result;
    }

    public static byte[] hmac_sha1(byte[] keyBytes, byte[] text) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
        hmacSha1.init(macKey);
        return hmacSha1.doFinal(text);
    }

    public static String generateOTP(byte[] secret, long movingFactor, int codeDigits, boolean addChecksum, int truncationOffset) throws NoSuchAlgorithmException, InvalidKeyException {
        String result = null;
        int digits = addChecksum ? codeDigits + 1 : codeDigits;
        byte[] text = new byte[8];
        for (int i = text.length - 1; i >= 0; --i) {
            text[i] = (byte)(movingFactor & 0xFFL);
            movingFactor >>= 8;
        }
        byte[] hash = OneTimePasswordAlgorithm.hmac_sha1(secret, text);
        int offset = hash[hash.length - 1] & 0xF;
        if (0 <= truncationOffset && truncationOffset < hash.length - 4) {
            offset = truncationOffset;
        }
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[codeDigits];
        if (addChecksum) {
            otp = otp * 10 + OneTimePasswordAlgorithm.calcChecksum(otp, codeDigits);
        }
        result = Integer.toString(otp);
        while (result.length() < digits) {
            result = "0" + result;
        }
        return result;
    }
}

