/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AmazonCognitoAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String guid) {
        return AmazonCognitoAuth.create(vertx, region, clientId, clientSecret, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String userPoolId, HttpClientOptions httpClientOptions) {
        if (region == null) {
            throw new IllegalStateException("region cannot be null");
        }
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setClientId(clientId).setClientSecret(clientSecret).setTenant(userPoolId).setSite("https://cognito-idp." + region + ".amazonaws.com/{tenant}").setTokenPath("/oauth2/token").setAuthorizationPath("/oauth2/authorize").setUserInfoPath("/oauth2/userInfo").setJwkPath("/.well-known/jwks.json").setLogoutPath("/logout").setScopeSeparator("+"));
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        return OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setScopeSeparator("+"));
    }
}

