/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.Oauth2CredentialsConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class Oauth2Credentials
implements Credentials {
    private String code;
    private String redirectUri;
    private String codeVerifier;
    private JsonObject jwt;
    private String assertion;
    private String password;
    private String username;
    private List<String> scopes;
    private OAuth2FlowType flow;

    public Oauth2Credentials() {
    }

    public Oauth2Credentials(JsonObject json) {
        Oauth2CredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getCode() {
        return this.code;
    }

    public Oauth2Credentials setCode(String code) {
        this.code = code;
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Oauth2Credentials setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public Oauth2Credentials setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Oauth2Credentials addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    public Oauth2Credentials setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public JsonObject getJwt() {
        return this.jwt;
    }

    public Oauth2Credentials setJwt(JsonObject jwt) {
        this.jwt = jwt;
        return this;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public Oauth2Credentials setAssertion(String assertion) {
        this.assertion = assertion;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public Oauth2Credentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public Oauth2Credentials setUsername(String username) {
        this.username = username;
        return this;
    }

    public OAuth2FlowType getFlow() {
        return this.flow;
    }

    public Oauth2Credentials setFlow(OAuth2FlowType flow) {
        this.flow = flow;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        Oauth2CredentialsConverter.toJson(this, json);
        return json;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        OAuth2FlowType flow = (OAuth2FlowType)((Object)arg);
        if (flow == null) {
            throw new CredentialValidationException("flow cannot be null");
        }
        switch (flow) {
            case CLIENT: {
                break;
            }
            case AUTH_CODE: {
                if (this.code == null || this.code.length() == 0) {
                    throw new CredentialValidationException("code cannot be null or empty");
                }
                if (this.redirectUri == null || this.redirectUri.length() != 0) break;
                throw new CredentialValidationException("redirectUri cannot be empty");
            }
            case AUTH_JWT: {
                if (this.jwt != null) break;
                throw new CredentialValidationException("json cannot be null");
            }
            case AAD_OBO: {
                if (this.assertion != null && this.assertion.length() != 0) break;
                throw new CredentialValidationException("assertion cannot be null or empty");
            }
            case PASSWORD: {
                if (this.username == null || this.username.length() == 0) {
                    throw new CredentialValidationException("username cannot be null or empty");
                }
                if (this.password != null && this.password.length() != 0) break;
                throw new CredentialValidationException("password cannot be null or empty");
            }
        }
    }

    public String toString() {
        return this.toJson().encode();
    }
}

